/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.jvm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.spongepowered.plugin.PluginCandidate;
import org.spongepowered.plugin.PluginEnvironment;
import org.spongepowered.plugin.PluginLanguageService;
import org.spongepowered.plugin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.PluginMetadataContainer;
import org.spongepowered.plugin.metadata.util.PluginMetadataHelper;

public abstract class JVMPluginLanguageService
implements PluginLanguageService<JVMPluginResource> {
    @Override
    public void initialize(PluginEnvironment environment) {
    }

    @Override
    public List<PluginCandidate<JVMPluginResource>> createPluginCandidates(PluginEnvironment environment, JVMPluginResource resource) {
        LinkedList<PluginCandidate<JVMPluginResource>> candidates = new LinkedList<PluginCandidate<JVMPluginResource>>();
        try (InputStream stream = this.getFileAsStream(resource.getPath(), this.getMetadataPath());){
            PluginMetadataContainer pluginMetadataContainer = this.createPluginMetadata(environment, this.getMetadataFileName(), stream).orElse(null);
            if (pluginMetadataContainer != null) {
                for (Map.Entry metadataEntry : pluginMetadataContainer.getAllMetadata().entrySet()) {
                    PluginMetadata metadata = (PluginMetadata)metadataEntry.getValue();
                    if (!metadata.getLoader().equals(this.getName())) continue;
                    candidates.add(new PluginCandidate<JVMPluginResource>(metadata, resource));
                }
            }
        }
        catch (IOException | URISyntaxException ex) {
            ex.printStackTrace();
        }
        return candidates;
    }

    public String getMetadataFileName() {
        return "plugins.json";
    }

    public String getMetadataPath() {
        return "META-INF/plugins.json";
    }

    public boolean isValidMetadata(PluginEnvironment environment, PluginMetadata pluginMetadata) {
        return true;
    }

    protected List<PluginCandidate<JVMPluginResource>> sortCandidates(List<PluginCandidate<JVMPluginResource>> pluginCandidates) {
        return pluginCandidates;
    }

    private InputStream getFileAsStream(Path rootDirectory, String relativePath) throws URISyntaxException, IOException {
        URI uri = rootDirectory.toUri();
        Path jarFile = null;
        if (uri.getRawSchemeSpecificPart().contains("!")) {
            jarFile = Paths.get(new URI(uri.getRawSchemeSpecificPart().split("!")[0]));
        } else if (rootDirectory.toString().endsWith(".jar")) {
            jarFile = rootDirectory;
        }
        if (jarFile != null) {
            JarFile jf = new JarFile(jarFile.toFile());
            JarEntry pluginMetadataJarEntry = jf.getJarEntry(relativePath);
            return jf.getInputStream(pluginMetadataJarEntry);
        }
        return Files.newInputStream(rootDirectory.resolve(relativePath), new OpenOption[0]);
    }

    private Optional<PluginMetadataContainer> createPluginMetadata(PluginEnvironment environment, String filename, InputStream stream) {
        PluginMetadataHelper metadataHelper = PluginMetadataHelper.builder().build();
        try {
            ArrayList<PluginMetadata> pluginMetadata = new ArrayList<PluginMetadata>(metadataHelper.read(stream));
            pluginMetadata.removeIf(nextMetadata -> !this.isValidMetadata(environment, (PluginMetadata)nextMetadata));
            if (pluginMetadata.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new PluginMetadataContainer(pluginMetadata));
        }
        catch (IOException e) {
            environment.getLogger().error("An error occurred reading plugin metadata file '{}'.", (Object)filename, (Object)e);
            return Optional.empty();
        }
    }
}

