/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.jvm.locator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.spongepowered.plugin.PluginEnvironment;
import org.spongepowered.plugin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.jvm.locator.JVMPluginResourceLocatorService;
import org.spongepowered.plugin.jvm.locator.ResourceType;

public final class ClasspathPluginResourceLocatorService
extends JVMPluginResourceLocatorService {
    private static final String NAME = "java_classpath";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<JVMPluginResource> locatePluginResources(PluginEnvironment environment) {
        Enumeration<URL> resources;
        environment.getLogger().info("Locating '{}' resources...", (Object)this.getName());
        ArrayList<JVMPluginResource> pluginFiles = new ArrayList<JVMPluginResource>();
        try {
            resources = ClassLoader.getSystemClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to enumerate classloader resources!");
        }
        while (resources.hasMoreElements()) {
            Manifest manifest;
            Throwable throwable;
            Path path;
            URI uri;
            URL url = resources.nextElement();
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                environment.getLogger().error("Malformed URL '{}'. Skipping...", (Object)url, (Object)e);
                continue;
            }
            if (uri.getRawSchemeSpecificPart().contains("!")) {
                URI parentUri;
                try {
                    parentUri = new URI(uri.getRawSchemeSpecificPart().split("!")[0]);
                }
                catch (URISyntaxException e) {
                    environment.getLogger().error("Malformed URI for Jar '{}. Skipping...", (Object)url, (Object)e);
                    continue;
                }
                try {
                    if (parentUri.equals(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI())) {
                        continue;
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                path = Paths.get(parentUri);
                try {
                    JarFile jf = new JarFile(path.toFile());
                    throwable = null;
                    try {
                        if (!this.isValidManifest(environment, jf.getManifest())) {
                            environment.getLogger().error("Manifest specified in '{}' is not valid. Skipping...", (Object)jf);
                            continue;
                        }
                        JarEntry pluginMetadataJarEntry = jf.getJarEntry(this.getMetadataPath());
                        if (pluginMetadataJarEntry == null) {
                            environment.getLogger().debug("'{}' does not contain any plugin metadata so it is not a plugin. Skipping...", (Object)jf);
                            continue;
                        }
                        pluginFiles.add(new JVMPluginResource(this.getName(), ResourceType.JAR, path));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jf == null) continue;
                        if (throwable != null) {
                            try {
                                jf.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jf.close();
                    }
                }
                catch (IOException e) {
                    environment.getLogger().error("Error reading '{}' as a Jar file. Skipping...", (Object)url, (Object)e);
                }
                continue;
            }
            try {
                throwable = null;
                try (InputStream stream = url.openStream();){
                    manifest = new Manifest(stream);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (IOException e) {
                environment.getLogger().error("Malformed URL '{}' in locator '{}'. Skipping...", (Object)url, (Object)e);
                continue;
            }
            if (!this.isValidManifest(environment, manifest)) {
                environment.getLogger().error("Manifest specified in '{}' is not valid. Skipping...", (Object)url);
                continue;
            }
            try {
                path = Paths.get(new URI("file://" + uri.getRawSchemeSpecificPart().substring(0, uri.getRawSchemeSpecificPart().length() - "META-INF/MANIFEST.MF".length())));
            }
            catch (URISyntaxException e) {
                environment.getLogger().error("Error creating root URI for '{}'. Skipping...", (Object)url, (Object)e);
                continue;
            }
            Path pluginMetadataFile = path.resolve(this.getMetadataPath());
            if (Files.notExists(pluginMetadataFile, new LinkOption[0])) {
                environment.getLogger().debug("'{}' does not contain any plugin metadata so it is not a plugin. Skipping...", (Object)path);
                continue;
            }
            pluginFiles.add(new JVMPluginResource(this.getName(), ResourceType.DIRECTORY, path));
        }
        environment.getLogger().info("Located [{}] resource(s) for '{}'...", (Object)pluginFiles.size(), (Object)this.getName());
        return pluginFiles;
    }
}

