/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.jvm.locator;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.spongepowered.plugin.PluginEnvironment;
import org.spongepowered.plugin.PluginKeys;
import org.spongepowered.plugin.jvm.locator.JVMPluginResource;
import org.spongepowered.plugin.jvm.locator.JVMPluginResourceLocatorService;
import org.spongepowered.plugin.jvm.locator.ResourceType;

public final class DirectoryPluginResourceLocatorService
extends JVMPluginResourceLocatorService {
    private static final String NAME = "java_directory";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<JVMPluginResource> locatePluginResources(PluginEnvironment environment) {
        environment.getLogger().info("Locating '{}' resources...", (Object)this.getName());
        ArrayList<JVMPluginResource> pluginFiles = new ArrayList<JVMPluginResource>();
        for (Path pluginsDir : environment.getBlackboard().get(PluginKeys.PLUGIN_DIRECTORIES).orElseGet(Collections::emptyList)) {
            if (Files.notExists(pluginsDir, new LinkOption[0])) {
                environment.getLogger().debug("Plugin directory '{}' does not exist for locator '{}'. Skipping...", (Object)pluginsDir, (Object)this.getName());
                continue;
            }
            try {
                for (Path path : Files.walk(pluginsDir, new FileVisitOption[0]).collect(Collectors.toList())) {
                    if (!Files.isRegularFile(path, new LinkOption[0]) || !path.getFileName().toString().endsWith(".jar")) continue;
                    try {
                        JarFile jf = new JarFile(path.toFile());
                        Throwable throwable = null;
                        try {
                            Manifest manifest = jf.getManifest();
                            if (!this.isValidManifest(environment, manifest)) {
                                environment.getLogger().error("Manifest specified in '{}' is not valid for locator '{}'. Skipping...", (Object)jf, (Object)this.getName());
                                continue;
                            }
                            JarEntry pluginMetadataJarEntry = jf.getJarEntry(this.getMetadataPath());
                            if (pluginMetadataJarEntry == null) {
                                environment.getLogger().debug("'{}' does not contain any plugin metadata so it is not a plugin. Skipping...", (Object)jf);
                                continue;
                            }
                            pluginFiles.add(new JVMPluginResource(this.getName(), ResourceType.JAR, path));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (jf == null) continue;
                            if (throwable != null) {
                                try {
                                    jf.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            jf.close();
                        }
                    }
                    catch (IOException e) {
                        environment.getLogger().error("Error reading '{}' as a Jar file when traversing directory resources for plugin discovery! Skipping...", (Object)path, (Object)e);
                    }
                }
            }
            catch (IOException ex) {
                environment.getLogger().error("Error walking plugins directory {}", (Object)pluginsDir, (Object)ex);
            }
        }
        environment.getLogger().info("Located [{}] resource(s) for '{}'...", (Object)pluginFiles.size(), (Object)this.getName());
        return pluginFiles;
    }
}

