/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api;

import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.plugin.PluginContainer;

public interface ResourceKey
extends Key {
    public static final String BRIGADIER_NAMESPACE = "brigadier";
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    public static final String SPONGE_NAMESPACE = "sponge";

    public static @NonNull ResourceKey brigadier(String value) {
        return ResourceKey.of(BRIGADIER_NAMESPACE, value);
    }

    public static @NonNull ResourceKey minecraft(String value) {
        return ResourceKey.of(MINECRAFT_NAMESPACE, value);
    }

    public static @NonNull ResourceKey sponge(String value) {
        return ResourceKey.of(SPONGE_NAMESPACE, value);
    }

    public static Builder builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public static ResourceKey of(String namespace, String value) {
        return ResourceKey.builder().namespace(namespace).value(value).build();
    }

    public static ResourceKey of(PluginContainer container, String value) {
        return ResourceKey.builder().namespace(container).value(value).build();
    }

    public static ResourceKey resolve(String formatted) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).resolve(formatted);
    }

    default public String getNamespace() {
        return this.namespace();
    }

    default public String getValue() {
        return this.value();
    }

    default public String getFormatted() {
        return this.asString();
    }

    default public String asString() {
        return this.namespace() + ':' + this.value();
    }

    default public int compareTo(Key o) {
        return super.compareTo(o);
    }

    public static interface Factory {
        public ResourceKey resolve(String var1);
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<ResourceKey, Builder> {
        public Builder namespace(String var1);

        default public Builder namespace(PluginContainer container) {
            return this.namespace(container.getMetadata().getId());
        }

        public Builder value(String var1);

        public ResourceKey build() throws IllegalStateException;
    }
}

