/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.api.command.registrar.tree.ClientCompletionKeys;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;

public interface Command {
    public static Builder builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public CommandResult process(CommandCause var1, String var2) throws CommandException;

    public List<String> getSuggestions(CommandCause var1, String var2) throws CommandException;

    public boolean canExecute(CommandCause var1);

    public Optional<Component> getShortDescription(CommandCause var1);

    public Optional<Component> getExtendedDescription(CommandCause var1);

    default public Optional<Component> getHelp(@NonNull CommandCause cause) {
        Optional<Component> shortDesc = this.getShortDescription(cause);
        Optional<Component> extended = this.getExtendedDescription(cause);
        if (extended.isPresent()) {
            if (shortDesc.isPresent()) {
                return Optional.of(((TextComponent.Builder)Component.text().append(new Component[]{shortDesc.get(), Component.newline(), Component.newline(), extended.get()})).build());
            }
            return extended;
        }
        return shortDesc;
    }

    public Component getUsage(CommandCause var1);

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Parameterized, Builder> {
        default public Builder child(Parameterized child, String ... keys) {
            return this.child(child, Arrays.asList(keys));
        }

        public Builder child(Parameterized var1, Iterable<String> var2);

        default public Builder children(Map<? extends Iterable<String>, ? extends Parameterized> children) {
            for (Map.Entry<? extends Iterable<String>, ? extends Parameterized> child : children.entrySet()) {
                this.child(child.getValue(), child.getKey());
            }
            return this;
        }

        public Builder flag(Flag var1);

        public Builder parameter(Parameter var1);

        default public Builder parameters(Parameter ... parameters) {
            return this.parameters(Arrays.asList(parameters));
        }

        default public Builder parameters(Iterable<Parameter> parameters) {
            for (Parameter parameter : parameters) {
                this.parameter(parameter);
            }
            return this;
        }

        public Builder setExecutor(CommandExecutor var1);

        public Builder setExtendedDescription(Function<CommandCause, Optional<Component>> var1);

        default public Builder setExtendedDescription(@Nullable Component extendedDescription) {
            Optional<Component> text = Optional.ofNullable(extendedDescription);
            return this.setExtendedDescription((CommandCause cause) -> text);
        }

        public Builder setShortDescription(Function<CommandCause, Optional<Component>> var1);

        default public Builder setShortDescription(@Nullable Component description) {
            Optional<Component> text = Optional.ofNullable(description);
            return this.setShortDescription((CommandCause cause) -> text);
        }

        public Builder setPermission(@Nullable String var1);

        public Builder setExecutionRequirements(@Nullable Predicate<CommandCause> var1);

        public Builder setTerminal(boolean var1);

        public Parameterized build();
    }

    public static interface Parameterized
    extends Command {
        public List<Flag> flags();

        public List<Parameter> parameters();

        public List<Parameter.Subcommand> subcommands();

        public boolean isTerminal();

        public Predicate<CommandCause> getExecutionRequirements();

        public CommandContext parseArguments(CommandCause var1, String var2) throws ArgumentParseException;

        public Optional<CommandExecutor> getExecutor();

        @Override
        default public CommandResult process(CommandCause cause, String arguments) throws CommandException {
            if (this.getExecutor().isPresent()) {
                return this.getExecutor().get().execute(this.parseArguments(cause, arguments));
            }
            throw new CommandException((Component)Component.text((String)"This command does not have an executor!"));
        }
    }

    public static interface Raw
    extends Command {
        default public CommandTreeNode.Root commandTree() {
            return (CommandTreeNode.Root)CommandTreeNode.root().executable().child("arguments", (CommandTreeNode.Argument)((CommandTreeNode.StringParser)ClientCompletionKeys.STRING.get().createNode().greedy().executable()).customSuggestions());
        }
    }
}

