/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.parameter.managed.standard;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.util.Builder;

public final class VariableValueParameters {
    private VariableValueParameters() {
    }

    public static <T> CatalogedTypeBuilder<T> registryEntryBuilder(Function<CommandContext, @Nullable RegistryHolder> holderProvider, RegistryType<T> registryKey) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createRegistryEntryBuilder(holderProvider, registryKey);
    }

    public static <T> CatalogedTypeBuilder<T> registryEntryBuilder(Function<CommandContext, @Nullable ? extends Registry<? extends T>> registryProvider) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createRegistryEntryBuilder(registryProvider);
    }

    public static <T> CatalogedTypeBuilder<T> registryEntryBuilder(RegistryType<T> defaultedRegistryReference) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createRegistryEntryBuilder(defaultedRegistryReference);
    }

    public static <T> StaticChoicesBuilder<T> staticChoicesBuilder(Class<T> returnType) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createStaticChoicesBuilder(returnType);
    }

    public static <T> DynamicChoicesBuilder<T> dynamicChoicesBuilder(Class<T> returnType) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createDynamicChoicesBuilder(returnType);
    }

    public static <T> LiteralBuilder<T> literalBuilder(Class<T> returnType) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createLiteralBuilder(returnType);
    }

    public static TextBuilder textBuilder() {
        return Sponge.getGame().getBuilderProvider().provide(TextBuilder.class);
    }

    public static <T extends Enum<T>> ValueParameter<T> enumChoices(Class<T> enumClass) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createEnumParameter(enumClass);
    }

    public static NumberRangeBuilder<Double> doubleRange() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createDoubleNumberRangeBuilder();
    }

    public static NumberRangeBuilder<Float> floatRange() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createFloatNumberRangeBuilder();
    }

    public static NumberRangeBuilder<Integer> integerRange() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createIntegerNumberRangeBuilder();
    }

    public static NumberRangeBuilder<Long> longRange() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createLongNumberRangeBuilder();
    }

    public static ValueParameter<String> validatedString(Pattern pattern) {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).createValidatedStringParameter(pattern);
    }

    public static interface Factory {
        public <T extends Enum<T>> ValueParameter<T> createEnumParameter(Class<T> var1);

        public <T> StaticChoicesBuilder<T> createStaticChoicesBuilder(Class<T> var1);

        public <T> DynamicChoicesBuilder<T> createDynamicChoicesBuilder(Class<T> var1);

        public <T> CatalogedTypeBuilder<T> createRegistryEntryBuilder(Function<CommandContext, @Nullable RegistryHolder> var1, RegistryType<T> var2);

        public <T> CatalogedTypeBuilder<T> createRegistryEntryBuilder(Function<CommandContext, @Nullable ? extends Registry<? extends T>> var1);

        public <T> CatalogedTypeBuilder<T> createRegistryEntryBuilder(RegistryType<T> var1);

        public <T> LiteralBuilder<T> createLiteralBuilder(Class<T> var1);

        public NumberRangeBuilder<Integer> createIntegerNumberRangeBuilder();

        public NumberRangeBuilder<Float> createFloatNumberRangeBuilder();

        public NumberRangeBuilder<Double> createDoubleNumberRangeBuilder();

        public NumberRangeBuilder<Long> createLongNumberRangeBuilder();

        public ValueParameter<String> createValidatedStringParameter(Pattern var1);
    }

    public static interface NumberRangeBuilder<T extends Number>
    extends Builder<ValueParameter<T>, NumberRangeBuilder<T>> {
        public NumberRangeBuilder<T> setMin(T var1);

        public NumberRangeBuilder<T> setMax(T var1);

        public ValueParameter<T> build();
    }

    public static interface TextBuilder
    extends Builder<ValueParameter<Component>, TextBuilder> {
        public TextBuilder setSerializer(ComponentSerializer<Component, ? extends Component, String> var1);

        public TextBuilder setSerializerSupplier(Supplier<ComponentSerializer<Component, ? extends Component, String>> var1);

        public TextBuilder setConsumeAllArguments(boolean var1);

        public ValueParameter<Component> build() throws IllegalStateException;
    }

    public static interface LiteralBuilder<T>
    extends Builder<ValueParameter<T>, LiteralBuilder<T>> {
        public LiteralBuilder<T> setLiteral(Supplier<? extends Collection<String>> var1);

        default public LiteralBuilder<T> setLiteral(Collection<String> literal) {
            return this.setLiteral(() -> literal);
        }

        public LiteralBuilder<T> setReturnValue(Supplier<T> var1);

        default public LiteralBuilder<T> setReturnValue(T returnValue) {
            return this.setReturnValue((T)((Supplier<Object>)() -> returnValue));
        }

        public ValueParameter<T> build();
    }

    public static interface DynamicChoicesBuilder<T>
    extends Builder<ValueParameter<T>, DynamicChoicesBuilder<T>> {
        public DynamicChoicesBuilder<T> setChoicesAndResults(Supplier<Map<String, ? extends T>> var1);

        public DynamicChoicesBuilder<T> setChoices(Supplier<? extends Collection<String>> var1);

        public DynamicChoicesBuilder<T> setResults(Function<String, ? extends T> var1);

        public DynamicChoicesBuilder<T> setShowInUsage(boolean var1);

        public ValueParameter<T> build();
    }

    public static interface StaticChoicesBuilder<T>
    extends Builder<ValueParameter<T>, StaticChoicesBuilder<T>> {
        default public StaticChoicesBuilder<T> choice(String choice, T returnedObject) {
            return this.choices(Collections.singleton(choice), () -> returnedObject);
        }

        default public StaticChoicesBuilder<T> choices(Map<String, ? extends T> choices) {
            for (Map.Entry<String, T> entry : choices.entrySet()) {
                this.choice(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public StaticChoicesBuilder<T> choices(Iterable<String> var1, Supplier<? extends T> var2);

        public StaticChoicesBuilder<T> setShowInUsage(boolean var1);

        public ValueParameter<T> build();
    }

    public static interface CatalogedTypeBuilder<T>
    extends Builder<ValueParameter<T>, CatalogedTypeBuilder<T>> {
        public static final Function<CommandContext, @Nullable RegistryHolder> GLOBAL_HOLDER_PROVIDER = in -> Sponge.getGame().registries();
        public static final Function<CommandContext, @Nullable RegistryHolder> SERVER_HOLDER_PROVIDER = in -> {
            try {
                return Sponge.getGame().getServer().registries();
            }
            catch (IllegalStateException ignored) {
                return null;
            }
        };

        public CatalogedTypeBuilder<T> defaultNamespace(String var1);

        public ValueParameter<T> build();
    }
}

