/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.value;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;

public interface MapValue<K, V>
extends Value<Map<K, V>> {
    public static <K, V> Mutable<K, V> mutableOf(Key<? extends MapValue<K, V>> key, Map<K, V> element) {
        return Value.mutableOf(key, element);
    }

    public static <K, V> Mutable<K, V> mutableOf(Supplier<? extends Key<? extends MapValue<K, V>>> key, Map<K, V> element) {
        return MapValue.mutableOf(key.get(), element);
    }

    public static <K, V> Immutable<K, V> immutableOf(Key<? extends MapValue<K, V>> key, Map<K, V> element) {
        return Value.immutableOf(key, element);
    }

    public static <K, V> Immutable<K, V> immutableOf(Supplier<? extends Key<? extends MapValue<K, V>>> key, Map<K, V> element) {
        return MapValue.immutableOf(key.get(), element);
    }

    @Override
    public Key<? extends MapValue<K, V>> getKey();

    public int size();

    public boolean containsKey(K var1);

    public boolean containsValue(V var1);

    public Set<K> keySet();

    public Set<Map.Entry<K, V>> entrySet();

    public Collection<V> values();

    public Mutable<K, V> asMutable();

    public Mutable<K, V> asMutableCopy();

    public Immutable<K, V> asImmutable();

    public static interface Immutable<K, V>
    extends MapValue<K, V>,
    Value.Immutable<Map<K, V>> {
        public Immutable<K, V> with(K var1, V var2);

        public Immutable<K, V> withAll(Map<K, V> var1);

        public Immutable<K, V> without(K var1);

        public Immutable<K, V> withoutAll(Iterable<K> var1);

        public Immutable<K, V> withoutAll(Predicate<Map.Entry<K, V>> var1);

        public Immutable<K, V> with(Map<K, V> var1);

        public Immutable<K, V> transform(Function<Map<K, V>, Map<K, V>> var1);

        @Override
        public Mutable<K, V> asMutable();

        @Override
        default public Mutable<K, V> asMutableCopy() {
            return this.asMutable();
        }

        @Override
        default public Immutable<K, V> asImmutable() {
            return this;
        }
    }

    public static interface Mutable<K, V>
    extends MapValue<K, V>,
    Value.Mutable<Map<K, V>> {
        public Mutable<K, V> put(K var1, V var2);

        public Mutable<K, V> putAll(Map<K, V> var1);

        public Mutable<K, V> remove(K var1);

        public Mutable<K, V> removeAll(Iterable<K> var1);

        public Mutable<K, V> removeAll(Predicate<Map.Entry<K, V>> var1);

        public Mutable<K, V> set(Map<K, V> var1);

        public Mutable<K, V> transform(Function<Map<K, V>, Map<K, V>> var1);

        public Mutable<K, V> copy();

        @Override
        default public Mutable<K, V> asMutable() {
            return this;
        }

        @Override
        default public Mutable<K, V> asMutableCopy() {
            return this.copy();
        }

        @Override
        public Immutable<K, V> asImmutable();
    }
}

