/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.math.vector.Vector2i;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vector4i;
import org.spongepowered.math.vector.VectorNi;
import org.spongepowered.math.vector.Vectord;
import org.spongepowered.math.vector.Vectorf;
import org.spongepowered.math.vector.Vectorl;

public final class Coerce {
    private static final Pattern listPattern = Pattern.compile("^([\\(\\[\\{]?)(.+?)([\\)\\]\\}]?)$");
    private static final String[] listPairings = new String[]{"([{", ")]}"};
    private static final Pattern vector2Pattern = Pattern.compile("^\\( *(-?[\\d\\.]{1,10}), *(-?[\\d\\.]{1,10}) *\\)$");

    private Coerce() {
    }

    public static String toString(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj.getClass().isArray()) {
            return Coerce.toList(obj).toString();
        }
        return obj.toString();
    }

    public static Optional<String> asString(@Nullable Object obj) {
        if (obj instanceof String) {
            return Optional.of((String)obj);
        }
        if (obj == null) {
            return Optional.empty();
        }
        return Optional.of(obj.toString());
    }

    public static List<?> toList(@Nullable Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return Coerce.primitiveArrayToList(obj);
            }
            return Arrays.asList((Object[])obj);
        }
        return Coerce.parseStringToList(obj.toString());
    }

    public static Optional<List<?>> asList(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof List) {
            return Optional.of((List)obj);
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return Optional.of(Coerce.primitiveArrayToList(obj));
            }
            return Optional.of(Arrays.asList((Object[])obj));
        }
        return Optional.of(Coerce.parseStringToList(obj.toString()));
    }

    public static <T> List<T> toListOf(@Nullable Object obj, Class<T> ofClass) {
        Objects.requireNonNull(ofClass, "ofClass");
        ArrayList filteredList = Lists.newArrayList();
        for (Object o : Coerce.toList(obj)) {
            if (ofClass.isAssignableFrom(o.getClass())) {
                filteredList.add(o);
                continue;
            }
            if (ofClass.equals(String.class)) {
                filteredList.add(Coerce.toString(o));
                continue;
            }
            if (ofClass.equals(Integer.TYPE) || ofClass.equals(Integer.class)) {
                filteredList.add(Coerce.toInteger(o));
                continue;
            }
            if (ofClass.equals(Float.TYPE) || ofClass.equals(Float.class)) {
                filteredList.add(new Float(Coerce.toDouble(o)));
                continue;
            }
            if (ofClass.equals(Double.TYPE) || ofClass.equals(Double.class)) {
                filteredList.add(Coerce.toDouble(o));
                continue;
            }
            if (!ofClass.equals(Boolean.TYPE) && !ofClass.equals(Boolean.class)) continue;
            filteredList.add(Coerce.toBoolean(o));
        }
        return filteredList;
    }

    public static boolean toBoolean(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof Boolean ? ((Boolean)obj).booleanValue() : obj.toString().trim().matches("^(1|true|yes)$");
    }

    public static Optional<Boolean> asBoolean(@Nullable Object obj) {
        if (obj instanceof Boolean) {
            return Optional.of((Boolean)obj);
        }
        if (obj instanceof Byte) {
            return Optional.of((Byte)obj != 0);
        }
        return Optional.empty();
    }

    public static int toInteger(@Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        String strObj = Coerce.sanitiseNumber(obj);
        Integer iParsed = Ints.tryParse((String)strObj);
        if (iParsed != null) {
            return iParsed;
        }
        Double dParsed = Doubles.tryParse((String)strObj);
        return dParsed != null ? dParsed.intValue() : 0;
    }

    public static Optional<Integer> asInteger(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).intValue());
        }
        try {
            return Optional.ofNullable(Integer.valueOf(obj.toString()));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String strObj = Coerce.sanitiseNumber(obj);
            Integer iParsed = Ints.tryParse((String)strObj);
            if (iParsed == null) {
                Double dParsed = Doubles.tryParse((String)strObj);
                return dParsed == null ? Optional.empty() : Optional.of(dParsed.intValue());
            }
            return Optional.of(iParsed);
        }
    }

    public static double toDouble(@Nullable Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        Double parsed = Doubles.tryParse((String)Coerce.sanitiseNumber(obj));
        return parsed != null ? parsed : 0.0;
    }

    public static Optional<Double> asDouble(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).doubleValue());
        }
        try {
            return Optional.ofNullable(Double.valueOf(obj.toString()));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String strObj = Coerce.sanitiseNumber(obj);
            Double dParsed = Doubles.tryParse((String)strObj);
            return dParsed == null ? Optional.empty() : Optional.of(dParsed);
        }
    }

    public static float toFloat(@Nullable Object obj) {
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        Float parsed = Floats.tryParse((String)Coerce.sanitiseNumber(obj));
        return parsed != null ? parsed.floatValue() : 0.0f;
    }

    public static Optional<Float> asFloat(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(Float.valueOf(((Number)obj).floatValue()));
        }
        try {
            return Optional.ofNullable(Float.valueOf(obj.toString()));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String strObj = Coerce.sanitiseNumber(obj);
            Double dParsed = Doubles.tryParse((String)strObj);
            return dParsed == null ? Optional.empty() : Optional.of(Float.valueOf(dParsed.floatValue()));
        }
    }

    public static short toShort(@Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        try {
            return Short.parseShort(Coerce.sanitiseNumber(obj));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static Optional<Short> asShort(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).shortValue());
        }
        try {
            return Optional.ofNullable(Short.parseShort(Coerce.sanitiseNumber(obj)));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return Optional.empty();
        }
    }

    public static byte toByte(@Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        try {
            return Byte.parseByte(Coerce.sanitiseNumber(obj));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static Optional<Byte> asByte(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).byteValue());
        }
        try {
            return Optional.ofNullable(Byte.parseByte(Coerce.sanitiseNumber(obj)));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return Optional.empty();
        }
    }

    public static long toLong(@Nullable Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(Coerce.sanitiseNumber(obj));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static Optional<Long> asLong(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Number) {
            return Optional.of(((Number)obj).longValue());
        }
        try {
            return Optional.ofNullable(Long.parseLong(Coerce.sanitiseNumber(obj)));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return Optional.empty();
        }
    }

    public static char toChar(@Nullable Object obj) {
        if (obj == null) {
            return '\u0000';
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        try {
            return obj.toString().charAt(0);
        }
        catch (Exception exception) {
            return '\u0000';
        }
    }

    public static Optional<Character> asChar(@Nullable Object obj) {
        if (obj == null) {
            return Optional.empty();
        }
        if (obj instanceof Character) {
            return Optional.of((Character)obj);
        }
        try {
            return Optional.of(Character.valueOf(obj.toString().charAt(0)));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public static <E extends Enum<E>> E toEnum(@Nullable Object obj, Class<E> enumClass) {
        return (E)Coerce.toEnum(obj, enumClass, ((Enum[])enumClass.getEnumConstants())[0]);
    }

    public static <E extends Enum<E>> E toEnum(@Nullable Object obj, Class<E> enumClass, E defaultValue) {
        Objects.requireNonNull(enumClass, "enumClass");
        Objects.requireNonNull(defaultValue, "defaultValue");
        if (obj == null) {
            return defaultValue;
        }
        if (enumClass.isAssignableFrom(obj.getClass())) {
            Enum enumObj = (Enum)obj;
            return (E)enumObj;
        }
        String strObj = obj.toString().trim();
        try {
            return Enum.valueOf(enumClass, strObj);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (Enum value : (Enum[])enumClass.getEnumConstants()) {
                if (!value.name().equalsIgnoreCase(strObj)) continue;
                return (E)value;
            }
            return defaultValue;
        }
    }

    public static <T> T toPseudoEnum(@Nullable Object obj, Class<T> pseudoEnumClass, Class<?> dictionaryClass, T defaultValue) {
        Objects.requireNonNull(pseudoEnumClass, "pseudoEnumClass");
        Objects.requireNonNull(dictionaryClass, "dictionaryClass");
        Objects.requireNonNull(defaultValue, "defaultValue");
        if (obj == null) {
            return defaultValue;
        }
        if (pseudoEnumClass.isAssignableFrom(obj.getClass())) {
            Object enumObj = obj;
            return (T)enumObj;
        }
        String strObj = obj.toString().trim();
        try {
            for (Field field : dictionaryClass.getFields()) {
                if ((field.getModifiers() & 8) == 0 || !pseudoEnumClass.isAssignableFrom(field.getType())) continue;
                String fieldName = field.getName();
                Object entry = field.get(null);
                if (!strObj.equalsIgnoreCase(fieldName)) continue;
                return (T)entry;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static Vector2i toVector2i(@Nullable Object obj) {
        if (obj == null) {
            return Vector2i.ZERO;
        }
        if (obj instanceof Vectorl) {
            obj = ((Vectorl)obj).toInt();
        } else if (obj instanceof Vectorf) {
            obj = ((Vectorf)obj).toInt();
        } else if (obj instanceof Vectord) {
            obj = ((Vectord)obj).toInt();
        }
        if (obj instanceof Vector2i) {
            return (Vector2i)obj;
        }
        if (obj instanceof Vector3i) {
            return new Vector2i((Vector3i)obj);
        }
        if (obj instanceof Vector4i) {
            return new Vector2i((Vector4i)obj);
        }
        if (obj instanceof VectorNi) {
            return new Vector2i((VectorNi)obj);
        }
        Matcher vecMatch = vector2Pattern.matcher(obj.toString());
        if (Coerce.listBracketsMatch(vecMatch)) {
            return new Vector2i(Integer.parseInt(vecMatch.group(1)), Integer.parseInt(vecMatch.group(2)));
        }
        List<?> list = Coerce.toList(obj);
        if (list.size() == 2) {
            return new Vector2i(Coerce.toInteger(list.get(0)), Coerce.toInteger(list.get(1)));
        }
        return Vector2i.ZERO;
    }

    private static String sanitiseNumber(Object obj) {
        String string = obj.toString().trim();
        if (string.length() < 1) {
            return "0";
        }
        Matcher candidate = listPattern.matcher(string);
        if (Coerce.listBracketsMatch(candidate)) {
            string = candidate.group(2).trim();
        }
        int decimal = string.indexOf(46);
        int comma = string.indexOf(44, decimal);
        if (decimal > -1 && comma > -1) {
            return Coerce.sanitiseNumber(string.substring(0, comma));
        }
        if (string.indexOf(45, 1) != -1) {
            return "0";
        }
        return string.replace(",", "").split(" ")[0];
    }

    private static boolean listBracketsMatch(Matcher candidate) {
        return candidate.matches() && listPairings[0].indexOf(candidate.group(1)) == listPairings[1].indexOf(candidate.group(3));
    }

    private static List<?> primitiveArrayToList(Object obj) {
        if (obj instanceof boolean[]) {
            return Booleans.asList((boolean[])((boolean[])obj));
        }
        if (obj instanceof char[]) {
            return Chars.asList((char[])((char[])obj));
        }
        if (obj instanceof byte[]) {
            return Bytes.asList((byte[])((byte[])obj));
        }
        if (obj instanceof short[]) {
            return Shorts.asList((short[])((short[])obj));
        }
        if (obj instanceof int[]) {
            return Ints.asList((int[])((int[])obj));
        }
        if (obj instanceof long[]) {
            return Longs.asList((long[])((long[])obj));
        }
        if (obj instanceof float[]) {
            return Floats.asList((float[])((float[])obj));
        }
        if (obj instanceof double[]) {
            return Doubles.asList((double[])((double[])obj));
        }
        return Collections.emptyList();
    }

    private static List<?> parseStringToList(String string) {
        Matcher candidate = listPattern.matcher(string);
        if (!Coerce.listBracketsMatch(candidate)) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (String part : candidate.group(2).split(",")) {
            if (part == null) continue;
            list.add(part);
        }
        return list;
    }
}

