/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import org.spongepowered.api.Engine;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.registry.ScopedRegistryHolder;
import org.spongepowered.api.service.context.ContextSource;
import org.spongepowered.api.util.annotation.DoNotStore;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.LocationCreator;
import org.spongepowered.api.world.ProtoWorld;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolumeCreator;
import org.spongepowered.api.world.volume.block.PhysicsAwareMutableBlockVolume;
import org.spongepowered.api.world.weather.WeatherUniverse;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@DoNotStore
public interface World<W extends World<W, L>, L extends Location<W, L>>
extends ForwardingAudience,
ProtoWorld<W>,
LocationCreator<W, L>,
PhysicsAwareMutableBlockVolume<W>,
ContextSource,
Viewer,
ArchetypeVolumeCreator,
WeatherUniverse,
ScopedRegistryHolder {
    public Engine getEngine();

    public WorldProperties getProperties();

    public boolean isLoaded();

    @Override
    public Collection<? extends Player> getPlayers();

    default public Iterable<? extends Audience> audiences() {
        return this.getPlayers();
    }

    default public Optional<? extends Player> getClosestPlayer(Vector3i position, double distance) {
        return this.getClosestPlayer(position.getX(), position.getY(), position.getZ(), distance, player -> true);
    }

    default public Optional<? extends Player> getClosestPlayer(Vector3i position, double distance, Predicate<? super Player> predicate) {
        return this.getClosestPlayer(position.getX(), position.getY(), position.getZ(), distance, predicate);
    }

    default public Optional<? extends Player> getClosestPlayer(Entity entity, double distance) {
        Vector3d position = entity.getLocation().getPosition();
        return this.getClosestPlayer(position.getFloorX(), position.getFloorY(), position.getFloorZ(), distance, player -> true);
    }

    default public Optional<? extends Player> getClosestPlayer(Entity entity, double distance, Predicate<? super Player> predicate) {
        Vector3d position = entity.getLocation().getPosition();
        return this.getClosestPlayer(position.getFloorX(), position.getFloorY(), position.getFloorZ(), distance, predicate);
    }

    default public Optional<? extends Player> getClosestPlayer(int x, int y, int z, double distance) {
        return this.getClosestPlayer(x, y, z, distance, player -> true);
    }

    public Optional<? extends Player> getClosestPlayer(int var1, int var2, int var3, double var4, Predicate<? super Player> var6);

    default public Chunk getChunkAtBlock(Vector3i blockPosition) {
        Objects.requireNonNull(blockPosition);
        Vector3i chunkPos = Sponge.getServer().getChunkLayout().forceToChunk(blockPosition);
        return this.getChunk(chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    public Chunk getChunkAtBlock(int var1, int var2, int var3);

    default public Chunk getChunk(Vector3i chunkPos) {
        Objects.requireNonNull(chunkPos);
        return this.getChunk(chunkPos.getX(), chunkPos.getY(), chunkPos.getZ());
    }

    public Chunk getChunk(int var1, int var2, int var3);

    default public Optional<Chunk> loadChunk(Vector3i chunkPosition, boolean shouldGenerate) {
        Objects.requireNonNull(chunkPosition);
        return this.loadChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ(), shouldGenerate);
    }

    public Optional<Chunk> loadChunk(int var1, int var2, int var3, boolean var4);

    public Iterable<Chunk> getLoadedChunks();
}

