/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldArchetypes;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.dimension.DimensionType;
import org.spongepowered.api.world.gen.WorldGenerationSettings;
import org.spongepowered.api.world.server.ServerWorldProperties;

@CatalogedBy(value={WorldArchetypes.class})
public interface WorldArchetype {
    public static Builder builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public boolean isEnabled();

    public boolean doesLoadOnStartup();

    public boolean doesKeepSpawnLoaded();

    public boolean doesGenerateSpawnOnLoad();

    public WorldGenerationSettings getWorldGeneratorSettings();

    public GameMode getGameMode();

    public DimensionType getDimensionType();

    public boolean isHardcore();

    public boolean areCommandsEnabled();

    public Difficulty getDifficulty();

    public boolean isPVPEnabled();

    public SerializationBehavior getSerializationBehavior();

    public static interface Builder
    extends CopyableBuilder<WorldArchetype, Builder>,
    org.spongepowered.api.util.Builder<WorldArchetype, Builder> {
        public Builder enabled(boolean var1);

        public Builder loadOnStartup(boolean var1);

        public Builder keepSpawnLoaded(boolean var1);

        public Builder generateSpawnOnLoad(boolean var1);

        public Builder worldGenerationSettings(WorldGenerationSettings var1);

        default public Builder gameMode(Supplier<? extends GameMode> gameMode) {
            return this.gameMode(gameMode.get());
        }

        public Builder gameMode(GameMode var1);

        default public Builder dimensionType(Supplier<? extends DimensionType> type) {
            return this.dimensionType(type.get());
        }

        public Builder dimensionType(DimensionType var1);

        default public Builder difficulty(Supplier<? extends Difficulty> difficulty) {
            return this.difficulty(difficulty.get());
        }

        public Builder difficulty(Difficulty var1);

        public Builder hardcore(boolean var1);

        public Builder pvpEnabled(boolean var1);

        public Builder commandsEnabled(boolean var1);

        default public Builder serializationBehavior(Supplier<? extends SerializationBehavior> behavior) {
            return this.serializationBehavior(behavior.get());
        }

        public Builder serializationBehavior(SerializationBehavior var1);

        @Override
        public Builder from(ServerWorldProperties var1);

        public WorldArchetype build();
    }
}

