/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.math.vector.Vector3d;

public interface WorldBorder {
    public static Builder builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public double getNewDiameter();

    public double getDiameter();

    public void setDiameter(double var1);

    default public void setDiameter(double diameter, long duration, TemporalUnit temporalUnit) {
        this.setDiameter(diameter, Duration.of(duration, temporalUnit));
    }

    public void setDiameter(double var1, Duration var3);

    default public void setDiameter(double startDiameter, double endDiameter, long duration, TemporalUnit temporalUnit) {
        this.setDiameter(startDiameter, endDiameter, Duration.of(duration, temporalUnit));
    }

    public void setDiameter(double var1, double var3, Duration var5);

    public Duration getTimeRemaining();

    public void setCenter(double var1, double var3);

    public Vector3d getCenter();

    public Duration getWarningTime();

    default public void setWarningTime(long time, TemporalUnit temporalUnit) {
        this.setWarningTime(Duration.of(time, temporalUnit));
    }

    public void setWarningTime(Duration var1);

    public double getWarningDistance();

    public void setWarningDistance(double var1);

    public double getDamageThreshold();

    public void setDamageThreshold(double var1);

    public double getDamageAmount();

    public void setDamageAmount(double var1);

    default public void copyPropertiesFrom(WorldBorder border) {
        this.setCenter(border.getCenter().getX(), border.getCenter().getZ());
        this.setDamageAmount(border.getDamageAmount());
        this.setDamageThreshold(border.getDamageThreshold());
        this.setDiameter(border.getDiameter(), border.getNewDiameter(), border.getTimeRemaining());
        this.setWarningDistance(border.getWarningDistance());
        this.setWarningTime(border.getWarningTime());
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<WorldBorder, Builder>,
    CopyableBuilder<WorldBorder, Builder> {
        @Override
        public Builder from(WorldBorder var1);

        public Builder diameter(double var1);

        public Builder center(double var1, double var3);

        default public Builder warningTime(long time, TemporalUnit temporalUnit) {
            return this.warningTime(Duration.of(time, temporalUnit));
        }

        public Builder warningTime(Duration var1);

        public Builder warningDistance(double var1);

        public Builder damageThreshold(double var1);

        public Builder damageAmount(double var1);

        public WorldBorder build();
    }
}

