/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.server;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.ServerWorldProperties;

public interface WorldManager {
    public Server getServer();

    public Optional<ServerWorld> getWorld(ResourceKey var1);

    public Collection<ServerWorld> getWorlds();

    default public Optional<ServerWorldProperties> getDefaultProperties() {
        return this.getProperties(this.getServer().getDefaultWorldKey());
    }

    public CompletableFuture<ServerWorldProperties> createProperties(ResourceKey var1, WorldArchetype var2);

    public CompletableFuture<ServerWorld> loadWorld(ResourceKey var1);

    public CompletableFuture<ServerWorld> loadWorld(ServerWorldProperties var1);

    public CompletableFuture<Boolean> unloadWorld(ResourceKey var1);

    public CompletableFuture<Boolean> unloadWorld(ServerWorld var1);

    public Optional<ServerWorldProperties> getProperties(ResourceKey var1);

    public Collection<ServerWorldProperties> getUnloadedProperties();

    public Collection<ServerWorldProperties> getAllProperties();

    public CompletableFuture<Boolean> saveProperties(ServerWorldProperties var1);

    public CompletableFuture<ServerWorldProperties> copyWorld(ResourceKey var1, ResourceKey var2);

    public CompletableFuture<ServerWorldProperties> moveWorld(ResourceKey var1, ResourceKey var2);

    public CompletableFuture<Boolean> deleteWorld(ResourceKey var1);
}

