/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingsFactory;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import org.spongepowered.api.Sponge;
import org.spongepowered.plugin.PluginContainer;

public final class Timings {
    private Timings() {
    }

    public static Timing of(PluginContainer plugin, String name) {
        Objects.requireNonNull(plugin, "PluginContainer cannot be null!");
        Objects.requireNonNull(name, "Timing name cannot be null!");
        return Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).of(plugin, name, null);
    }

    public static Timing of(PluginContainer plugin, String name, Timing groupHandler) {
        Objects.requireNonNull(plugin, "PluginContainer cannot be null!");
        Objects.requireNonNull(name, "Timing name cannot be null!");
        Objects.requireNonNull(groupHandler, "Group Handler cannot be null!");
        return Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).of(plugin, name, groupHandler);
    }

    public static Timing ofStart(PluginContainer plugin, String name) {
        Timing timing = Timings.of(plugin, name);
        timing.startTimingIfSync();
        return timing;
    }

    public static Timing ofStart(PluginContainer plugin, String name, Timing groupHandler) {
        Objects.requireNonNull(plugin, "PluginContainer cannot be null!");
        Objects.requireNonNull(name, "Timing name cannot be null!");
        Objects.requireNonNull(groupHandler, "Group Handler cannot be null!");
        Timing timing = Timings.of(plugin, name, groupHandler);
        timing.startTimingIfSync();
        return timing;
    }

    public static boolean isTimingsEnabled() {
        return Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).isTimingsEnabled();
    }

    public static void setTimingsEnabled(boolean enabled) {
        Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).setTimingsEnabled(enabled);
    }

    public static boolean isVerboseTimingsEnabled() {
        return Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).isVerboseTimingsEnabled();
    }

    public static void setVerboseTimingsEnabled(boolean enabled) {
        Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).setVerboseTimingsEnabled(enabled);
    }

    public static int getHistoryInterval() {
        return Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).getHistoryInterval();
    }

    public static void setHistoryInterval(int interval) {
        Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).setHistoryInterval(interval);
    }

    public static int getHistoryLength() {
        return Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).getHistoryLength();
    }

    public static void setHistoryLength(int length) {
        Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).setHistoryLength(length);
    }

    public static void reset() {
        Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).reset();
    }

    public static void generateReport(Audience channel) {
        Sponge.getGame().getFactoryProvider().provide(TimingsFactory.class).generateReport(channel);
    }
}

