/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.block;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.transaction.BlockTransaction;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;

public interface ChangeBlockEvent
extends Event {
    public ServerWorld getWorld();

    public static interface Post
    extends ChangeBlockEvent {
        public List<BlockTransactionReceipt> getReceipts();
    }

    public static interface All
    extends ChangeBlockEvent,
    Cancellable {
        public List<BlockTransaction> getTransactions();

        default public Stream<BlockTransaction> getTransactions(Operation operation) {
            Objects.requireNonNull(operation, "Operation cannot be null");
            return this.getTransactions().stream().filter(transaction -> transaction.getOperation().equals(operation));
        }

        default public List<BlockTransaction> invalidate(Predicate<ServerLocation> predicate) {
            return this.getTransactions().stream().filter(blockTransaction -> {
                if (!predicate.test(((BlockSnapshot)blockTransaction.getOriginal()).getLocation().get())) {
                    blockTransaction.setValid(false);
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }

        default public void invalidateAll() {
            this.getTransactions().forEach(Transaction::invalidate);
        }
    }

    public static interface Pre
    extends ChangeBlockEvent,
    Cancellable {
        public List<ServerLocation> getLocations();
    }
}

