/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.state;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.state.State;
import org.spongepowered.api.state.StateContainer;
import org.spongepowered.api.state.StateProperty;
import org.spongepowered.api.util.CopyableBuilder;

public interface StateMatcher<S extends State<S>>
extends Predicate<S> {
    public static Builder<BlockState, BlockType> blockStateMatcherBuilder() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).blockStateMatcherBuilder();
    }

    public static Builder<FluidState, FluidType> fluidStateMatcherBuilder() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).fluidStateMatcherBuilder();
    }

    public boolean matches(S var1);

    public List<S> getCompatibleStates();

    @Override
    default public boolean test(S state) {
        return this.matches(state);
    }

    public static interface Builder<S extends State<S>, T extends StateContainer<S>>
    extends org.spongepowered.api.util.Builder<StateMatcher<S>, Builder<S, T>>,
    CopyableBuilder<StateMatcher<S>, Builder<S, T>> {
        default public Builder<S, T> type(Supplier<? extends T> type) {
            return this.type((StateContainer)type.get());
        }

        public Builder<S, T> type(T var1);

        public Builder<S, T> supportsStateProperty(StateProperty<@NonNull ?> var1);

        default public Builder<S, T> supportsStateProperty(Supplier<? extends StateProperty<@NonNull ?>> stateProperty) {
            return this.supportsStateProperty(stateProperty.get());
        }

        public <V extends Comparable<V>> Builder<S, T> stateProperty(StateProperty<V> var1, V var2);

        default public <V extends Comparable<V>> Builder<S, T> stateProperty(Supplier<? extends StateProperty<V>> stateProperty, V value) {
            return this.stateProperty(stateProperty.get(), value);
        }

        public Builder<S, T> matcher(KeyValueMatcher<?> var1);

        public StateMatcher<S> build();
    }

    public static interface Factory {
        public Builder<BlockState, BlockType> blockStateMatcherBuilder();

        public Builder<FluidState, FluidType> fluidStateMatcherBuilder();
    }
}

