/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.stream;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.stream.VolumeCollector;
import org.spongepowered.api.world.volume.stream.VolumeConsumer;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeFlatMapper;
import org.spongepowered.api.world.volume.stream.VolumeMapper;
import org.spongepowered.api.world.volume.stream.VolumePredicate;
import org.spongepowered.math.vector.Vector3i;

public interface VolumeStream<V extends Volume, T> {
    public V getVolume();

    public VolumeStream<V, T> filter(VolumePredicate<V, T> var1);

    default public VolumeStream<V, T> filter(Predicate<VolumeElement<V, ? super T>> predicate) {
        return this.filter((V volume, Supplier<T> element, int x, int y, int z) -> predicate.test(VolumeElement.of(volume, element, new Vector3i(x, y, z))));
    }

    public <Out> VolumeStream<V, Out> map(VolumeMapper<V, T, Out> var1);

    default public <Out> VolumeStream<V, Out> map(Function<VolumeElement<V, T>, ? extends Out> mapper) {
        return this.map((V volume, Supplier<T> value, int x, int y, int z) -> mapper.apply(VolumeElement.of(volume, value, new Vector3i(x, y, z))));
    }

    public VolumeStream<V, Optional<? extends T>> flatMap(VolumeFlatMapper<V, T> var1);

    default public VolumeStream<V, Optional<? extends T>> flatMap(Function<VolumeElement<V, T>, Optional<? extends T>> mapper) {
        return this.flatMap((V volume, Supplier<T> value, int x, int y, int z) -> (Optional)mapper.apply(VolumeElement.of(volume, value, new Vector3i(x, y, z))));
    }

    public long count();

    public boolean allMatch(VolumePredicate<V, ? super T> var1);

    default public boolean allMatch(Predicate<VolumeElement<V, ? super T>> predicate) {
        return this.allMatch((V volume, Supplier<? super T> element, int x, int y, int z) -> predicate.test(VolumeElement.of(volume, element, new Vector3i(x, y, z))));
    }

    public boolean noneMatch(VolumePredicate<V, ? super T> var1);

    default public boolean noneMatch(Predicate<VolumeElement<V, ? super T>> predicate) {
        return this.noneMatch((V volume, Supplier<? super T> element, int x, int y, int z) -> predicate.test(VolumeElement.of(volume, element, new Vector3i(x, y, z))));
    }

    public boolean anyMatch(VolumePredicate<V, ? super T> var1);

    default public boolean anyMatch(Predicate<VolumeElement<V, ? super T>> predicate) {
        return this.anyMatch((V volume, Supplier<? super T> element, int x, int y, int z) -> predicate.test(VolumeElement.of(volume, element, new Vector3i(x, y, z))));
    }

    public Optional<VolumeElement<V, T>> findFirst();

    public Optional<VolumeElement<V, T>> findAny();

    public Stream<VolumeElement<V, T>> toStream();

    default public <W extends MutableVolume> void apply(VolumeCollector<W, T, ?> collector) {
        this.applyUntil(collector, result -> true);
    }

    public <W extends MutableVolume, R> void applyUntil(VolumeCollector<W, T, R> var1, Predicate<R> var2);

    public void forEach(VolumeConsumer<V, T> var1);

    default public void forEach(Consumer<VolumeElement<V, T>> consumer) {
        this.forEach((V volume, T type, int x, int y, int z) -> consumer.accept(VolumeElement.of(volume, type, new Vector3i(x, y, z))));
    }
}

