/*
 * This file is part of SpongeAPI, licensed under the MIT License (MIT).
 *
 * Copyright (c) SpongePowered <https://www.spongepowered.org>
 * Copyright (c) contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.spongepowered.api.world.schematic;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;

import java.util.Objects;
import java.util.Optional;

public interface PaletteReference<T, R> {

    RegistryType<R> registry();

    String value();

    default Optional<T> resolve(final RegistryHolder holder, final PaletteType<T, R> type) {
        return type.getResolver().apply(this.value(), holder.registry(this.registry()));
    }

    static <T, R> PaletteReference<T, R> byString(final RegistryType<R> registryType, final String value) {
        final String stringId = Objects.requireNonNull(value, "String cannot be null!");
        if (stringId.isEmpty()) {
            throw new IllegalArgumentException("String cannot be empty to refer to an object in a Palette");
        }
        return Sponge.getGame().getFactoryProvider().provide(PaletteReference.Factory.class)
            .stringReference(
                Objects.requireNonNull(registryType, "RegistryType cannot be null!"),
                stringId
            );
    }

    interface Factory {

        <T, R> PaletteReference<T, R> stringReference(RegistryType<R> type, String value);

    }

}
