/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage.source.common;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;

public abstract class AbstractDamageSourceBuilder<T extends DamageSource, B extends DamageSource.DamageSourceBuilder<T, B>>
implements DamageSource.DamageSourceBuilder<T, B> {
    protected boolean scales = false;
    protected boolean bypasses = false;
    protected boolean explosion = false;
    protected boolean absolute = false;
    protected boolean magical = false;
    protected boolean creative = false;
    protected boolean fire = false;
    protected @Nullable Double exhaustion = null;
    protected DamageType damageType = null;

    @Override
    public B fire() {
        this.fire = true;
        return (B)this;
    }

    @Override
    public B scalesWithDifficulty() {
        this.scales = true;
        return (B)this;
    }

    @Override
    public B bypassesArmor() {
        this.bypasses = true;
        return (B)this;
    }

    @Override
    public B explosion() {
        this.explosion = true;
        return (B)this;
    }

    @Override
    public B absolute() {
        this.absolute = true;
        return (B)this;
    }

    @Override
    public B magical() {
        this.magical = true;
        return (B)this;
    }

    @Override
    public B creative() {
        this.creative = true;
        return (B)this;
    }

    @Override
    public B exhaustion(double exhaustion) {
        this.exhaustion = exhaustion;
        return (B)this;
    }

    @Override
    public B type(DamageType damageType) {
        this.damageType = Objects.requireNonNull(damageType, "DamageType cannot be null!");
        return (B)this;
    }

    @Override
    public B from(T value) {
        this.reset();
        this.scales = value.isScaledByDifficulty();
        this.absolute = value.isAbsolute();
        this.bypasses = value.isBypassingArmor();
        this.explosion = value.isExplosive();
        this.creative = value.doesAffectCreative();
        this.magical = value.isMagic();
        this.exhaustion = value.getExhaustion();
        this.damageType = value.getType();
        return (B)this;
    }

    @Override
    public B reset() {
        this.scales = false;
        this.bypasses = false;
        this.explosion = false;
        this.absolute = false;
        this.magical = false;
        this.creative = false;
        this.exhaustion = null;
        this.damageType = null;
        return (B)this;
    }
}

