/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.impl.entity;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierType;
import org.spongepowered.api.event.cause.entity.damage.ModifierFunction;
import org.spongepowered.api.event.entity.AttackEntityEvent;
import org.spongepowered.api.event.impl.entity.AbstractModifierEvent;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.annotation.eventgen.UseField;

public abstract class AbstractAttackEntityEvent
extends AbstractModifierEvent<DamageFunction, DamageModifier>
implements AttackEntityEvent {
    @UseField
    protected double originalDamage;
    @UseField
    protected List<DamageFunction> originalFunctions;
    @UseField
    protected double baseDamage;

    @Override
    protected final void init() {
        this.originalFunctions = this.init(this.originalDamage, this.originalFunctions);
        this.baseDamage = this.originalDamage;
    }

    @Override
    public final double getOriginalModifierDamage(DamageModifier damageModifier) {
        Objects.requireNonNull(damageModifier, "Damage modifier cannot be null!");
        for (Tuple tuple : this.originalModifiers) {
            if (!((DamageModifier)tuple.getFirst()).equals(damageModifier)) continue;
            return (Double)tuple.getSecond();
        }
        throw new IllegalArgumentException("The provided damage modifier is not applicable: " + damageModifier.toString());
    }

    @Override
    public final double getOriginalFinalDamage() {
        return this.originalFinalAmount;
    }

    @Override
    public final Map<DamageModifier, Double> getOriginalDamages() {
        return this.originalModifierMap;
    }

    @Override
    public final double getFinalOutputDamage() {
        return this.getFinalAmount(this.baseDamage);
    }

    @Override
    public final boolean isModifierApplicable(DamageModifier damageModifier) {
        return this.modifiers.containsKey(Objects.requireNonNull(damageModifier));
    }

    @Override
    public final double getOutputDamage(DamageModifier damageModifier) {
        if (!this.modifiers.containsKey(Objects.requireNonNull(damageModifier, "Damage Modifier cannot be null!"))) {
            throw new IllegalArgumentException("The provided damage modifier is not applicable: " + damageModifier.toString());
        }
        return (Double)this.modifiers.get(Objects.requireNonNull(damageModifier));
    }

    @Override
    public final void setOutputDamage(DamageModifier damageModifier, DoubleUnaryOperator function) {
        Objects.requireNonNull(damageModifier, "Damage modifier was null!");
        Objects.requireNonNull(function, "Function was null!");
        int indexToAddTo = 0;
        boolean addAtEnd = true;
        Iterator iterator = this.modifierFunctions.iterator();
        while (iterator.hasNext()) {
            ModifierFunction tuple = (ModifierFunction)iterator.next();
            if (((DamageModifier)tuple.getModifier()).equals(damageModifier)) {
                iterator.remove();
                addAtEnd = false;
                break;
            }
            ++indexToAddTo;
        }
        if (addAtEnd) {
            this.modifierFunctions.add(new DamageFunction(damageModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddTo, new DamageFunction(damageModifier, function));
        }
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    public void addDamageModifierBefore(DamageModifier damageModifier, DoubleUnaryOperator function, Set<DamageModifierType> before) {
        Objects.requireNonNull(damageModifier, "Damage modifier was null!");
        Objects.requireNonNull(function, "Function was null!");
        int indexToAddBefore = -1;
        int index = 0;
        for (ModifierFunction tuple : this.modifierFunctions) {
            if (((DamageModifier)tuple.getModifier()).equals(damageModifier)) {
                throw new IllegalArgumentException("Cannot add a duplicate modifier");
            }
            if (before.contains(((DamageModifier)tuple.getModifier()).getType())) {
                indexToAddBefore = index;
            }
            ++index;
        }
        if (indexToAddBefore == -1) {
            this.modifierFunctions.add(new DamageFunction(damageModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddBefore, new DamageFunction(damageModifier, function));
        }
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    public void addDamageModifierAfter(DamageModifier damageModifier, DoubleUnaryOperator function, Set<DamageModifierType> after) {
        Objects.requireNonNull(damageModifier, "Damage modifier was null!");
        Objects.requireNonNull(function, "Function was null!");
        int indexToAddAfter = -1;
        int index = 0;
        for (ModifierFunction tuple : this.modifierFunctions) {
            if (((DamageModifier)tuple.getModifier()).equals(damageModifier)) {
                throw new IllegalArgumentException("Cannot add a duplicate modifier");
            }
            if (after.contains(((DamageModifier)tuple.getModifier()).getType())) {
                indexToAddAfter = index;
            }
            ++index;
        }
        if (indexToAddAfter == -1) {
            this.modifierFunctions.add(new DamageFunction(damageModifier, function));
        } else {
            this.modifierFunctions.add(indexToAddAfter + 1, new DamageFunction(damageModifier, function));
        }
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    public double getBaseOutputDamage() {
        return this.baseDamage;
    }

    @Override
    public final void setBaseOutputDamage(double baseDamage) {
        this.baseDamage = baseDamage;
        this.recalculateDamages(this.baseDamage);
    }

    @Override
    protected DamageFunction convertTuple(DamageModifier obj, DoubleUnaryOperator function) {
        return new DamageFunction(obj, function);
    }

    @Override
    public List<DamageFunction> getModifiers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModifierFunction entry : this.modifierFunctions) {
            if (entry instanceof DamageFunction) {
                builder.add((Object)((DamageFunction)entry));
                continue;
            }
            builder.add((Object)new DamageFunction((DamageModifier)entry.getModifier(), entry.getFunction()));
        }
        return builder.build();
    }
}

