/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.economy.account;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.service.economy.transaction.TransferResult;

public interface Account
extends Contextual {
    public Component getDisplayName();

    public BigDecimal getDefaultBalance(Currency var1);

    public boolean hasBalance(Currency var1, Set<Context> var2);

    default public boolean hasBalance(Currency currency) {
        return this.hasBalance(currency, this.getActiveContexts());
    }

    public BigDecimal getBalance(Currency var1, Set<Context> var2);

    default public BigDecimal getBalance(Currency currency) {
        return this.getBalance(currency, this.getActiveContexts());
    }

    public Map<Currency, BigDecimal> getBalances(Set<Context> var1);

    default public Map<Currency, BigDecimal> getBalances() {
        return this.getBalances(this.getActiveContexts());
    }

    public TransactionResult setBalance(Currency var1, BigDecimal var2, Set<Context> var3);

    default public TransactionResult setBalance(Currency currency, BigDecimal amount) {
        return this.setBalance(currency, amount, this.getActiveContexts());
    }

    public Map<Currency, TransactionResult> resetBalances(Set<Context> var1);

    default public Map<Currency, TransactionResult> resetBalances() {
        return this.resetBalances(this.getActiveContexts());
    }

    public TransactionResult resetBalance(Currency var1, Set<Context> var2);

    default public TransactionResult resetBalance(Currency currency) {
        return this.resetBalance(currency, this.getActiveContexts());
    }

    public TransactionResult deposit(Currency var1, BigDecimal var2, Set<Context> var3);

    default public TransactionResult deposit(Currency currency, BigDecimal amount) {
        return this.deposit(currency, amount, this.getActiveContexts());
    }

    public TransactionResult withdraw(Currency var1, BigDecimal var2, Set<Context> var3);

    default public TransactionResult withdraw(Currency currency, BigDecimal amount) {
        return this.withdraw(currency, amount, this.getActiveContexts());
    }

    public TransferResult transfer(Account var1, Currency var2, BigDecimal var3, Set<Context> var4);

    default public TransferResult transfer(Account to, Currency currency, BigDecimal amount) {
        return this.transfer(to, currency, amount, this.getActiveContexts());
    }
}

