/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.chunk;

import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.annotation.DoNotStore;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.chunk.ProtoChunk;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.math.vector.Vector3i;

@DoNotStore
public interface Chunk
extends ProtoChunk<Chunk>,
EntityVolume.Mutable<Chunk> {
    public World<?, ?> getWorld();

    public boolean loadChunk(boolean var1);

    public boolean unloadChunk();

    @Override
    public long getInhabitedTime();

    default public Optional<Chunk> getNeighbor(Direction direction) {
        return this.getNeighbor(direction, false);
    }

    default public Optional<Chunk> getNeighbor(Direction direction, boolean shouldLoad) {
        Optional<Vector3i> neighborPosition = Sponge.getServer().getChunkLayout().moveToChunk(this.getChunkPosition(), direction);
        return neighborPosition.flatMap(vector3i -> this.getWorld().loadChunk((Vector3i)vector3i, shouldLoad));
    }
}

