/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.explosion;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.server.ServerLocation;

public interface Explosion
extends Locatable {
    public static Builder builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public Optional<Explosive> getSourceExplosive();

    public float getRadius();

    public boolean canCauseFire();

    public boolean shouldPlaySmoke();

    public boolean shouldBreakBlocks();

    public boolean shouldDamageEntities();

    default public int getResolution() {
        return 16;
    }

    default public float getRandomness() {
        return 1.0f;
    }

    default public double getKnockback() {
        return 1.0;
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Explosion, Builder>,
    CopyableBuilder<Explosion, Builder> {
        public Builder location(ServerLocation var1);

        public Builder sourceExplosive(@Nullable Explosive var1);

        public Builder radius(float var1);

        public Builder canCauseFire(boolean var1);

        public Builder shouldDamageEntities(boolean var1);

        public Builder shouldPlaySmoke(boolean var1);

        public Builder shouldBreakBlocks(boolean var1);

        default public Builder resolution(int resolution) {
            return this;
        }

        default public Builder randomness(float randomness) {
            return this;
        }

        default public Builder knockback(double knockback) {
            return this;
        }

        public Explosion build() throws IllegalArgumentException;
    }
}

