/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.schematic;

import java.util.Collection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolumeCreator;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeVolume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.block.entity.BlockEntityVolume;
import org.spongepowered.api.world.volume.game.LocationBaseDataHolder;
import org.spongepowered.math.vector.Vector3d;

public interface Schematic
extends ArchetypeVolume,
LocationBaseDataHolder.Mutable {
    public static final String METADATA_NAME = "Name";
    public static final String METADATA_AUTHOR = "Author";
    public static final String METADATA_DATE = "Date";
    public static final String METADATA_REQUIRED_MODS = "RequiredMods";

    public static Builder builder() {
        return Sponge.getGame().getBuilderProvider().provide(Builder.class);
    }

    public Palette<BlockState, BlockType> getBlockPalette();

    public Palette<Biome, Biome> getBiomePalette();

    public DataView getMetadata();

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Schematic, Builder>,
    CopyableBuilder<Schematic, Builder> {
        public Builder blocks(BlockVolume var1);

        public Builder blockEntities(BlockEntityVolume var1);

        public Builder entities(EntityArchetypeVolume var1);

        public Builder creator(ArchetypeVolumeCreator var1);

        public Builder volume(ArchetypeVolume var1);

        public Builder blockPalette(Palette<BlockState, BlockType> var1);

        public Builder biomePalette(Palette<Biome, Biome> var1);

        public Builder blockPaletteType(PaletteType<BlockState, BlockType> var1);

        public Builder biomePaletteType(PaletteType<Biome, Biome> var1);

        public Builder entity(EntityArchetype var1);

        public Builder entity(EntityArchetype var1, Vector3d var2);

        public Builder entity(EntityArchetypeEntry var1);

        public Builder entities(Collection<EntityArchetypeEntry> var1);

        public Builder metadata(DataView var1);

        public Builder metaValue(String var1, Object var2);

        public Schematic build() throws IllegalArgumentException;
    }
}

