/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.server;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKeyed;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.datapack.DataPackSerializable;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.api.util.ResourceKeyedBuilder;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.math.vector.Vector3i;

public interface WorldTemplate
extends ResourceKeyed,
DataPackSerializable {
    public static WorldTemplate overworld() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).overworld();
    }

    public static WorldTemplate overworldCaves() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).overworldCaves();
    }

    public static WorldTemplate theNether() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).theNether();
    }

    public static WorldTemplate theEnd() {
        return Sponge.getGame().getFactoryProvider().provide(Factory.class).theEnd();
    }

    public static Builder builder() {
        return (Builder)Sponge.getGame().getBuilderProvider().provide(Builder.class).reset();
    }

    public Optional<Component> displayName();

    public RegistryReference<WorldType> worldType();

    public ChunkGenerator generator();

    public WorldGenerationConfig generationConfig();

    public Optional<RegistryReference<GameMode>> gameMode();

    public Optional<RegistryReference<Difficulty>> difficulty();

    public Optional<SerializationBehavior> serializationBehavior();

    public boolean loadOnStartup();

    public boolean performsSpawnLogic();

    public Optional<Boolean> hardcore();

    public Optional<Boolean> commands();

    public Optional<Boolean> pvp();

    public Optional<Integer> viewDistance();

    public Optional<Vector3i> spawnPosition();

    default public Builder asBuilder() {
        return (Builder)Sponge.getGame().getBuilderProvider().provide(Builder.class).from(this);
    }

    public static interface Factory {
        public WorldTemplate overworld();

        public WorldTemplate overworldCaves();

        public WorldTemplate theNether();

        public WorldTemplate theEnd();
    }

    public static interface Builder
    extends ResourceKeyedBuilder<WorldTemplate, Builder>,
    CopyableBuilder<WorldTemplate, Builder> {
        public Builder displayName(@Nullable Component var1);

        public Builder worldType(RegistryReference<WorldType> var1);

        public Builder generator(ChunkGenerator var1);

        public Builder generationConfig(WorldGenerationConfig var1);

        public Builder gameMode(RegistryReference<GameMode> var1);

        public Builder difficulty(RegistryReference<Difficulty> var1);

        public Builder serializationBehavior(@Nullable SerializationBehavior var1);

        public Builder loadOnStartup(boolean var1);

        public Builder performsSpawnLogic(boolean var1);

        public Builder hardcore(@Nullable Boolean var1);

        public Builder commands(@Nullable Boolean var1);

        public Builder pvp(@Nullable Boolean var1);

        public Builder viewDistance(@Nullable Integer var1);

        public Builder spawnPosition(@Nullable Vector3i var1);
    }
}

