/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.game;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.world.chunk.ProtoChunk;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.math.vector.Vector3i;

public interface ChunkVolume
extends BlockVolume {
    public ProtoChunk<@NonNull ?> getChunk(int var1, int var2, int var3);

    default public ProtoChunk<@NonNull ?> getChunk(Vector3i chunkPosition) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.getChunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ());
    }

    default public ProtoChunk<@NonNull ?> getChunkAtBlock(Vector3i blockPosition) {
        Objects.requireNonNull(blockPosition, "blockPosition");
        return this.getChunkAtBlock(blockPosition.getX(), blockPosition.getY(), blockPosition.getZ());
    }

    public ProtoChunk<@NonNull ?> getChunkAtBlock(int var1, int var2, int var3);

    public boolean isChunkLoaded(int var1, int var2, int var3, boolean var4);

    default public boolean isChunkLoaded(Vector3i position, boolean allowEmpty) {
        Objects.requireNonNull(position, "position");
        return this.isChunkLoaded(position.getX(), position.getY(), position.getZ(), allowEmpty);
    }

    public boolean hasChunk(int var1, int var2, int var3);

    public boolean hasChunk(Vector3i var1);
}

