/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.stream;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.stream.VolumeApplicator;
import org.spongepowered.api.world.volume.stream.VolumeApplicators;
import org.spongepowered.api.world.volume.stream.VolumeCollector;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslator;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslators;

public final class VolumeCollectors {
    public static <W extends World<W, ?>> VolumeCollector<W, BlockState, Boolean> applyBlocksToWorld(W world, BlockChangeFlag flag) {
        Objects.requireNonNull(flag, "BlockChangeFlag cannot be null!");
        return VolumeCollectors.of(world, VolumePositionTranslators.identity(), VolumeApplicators.applyBlocks(flag));
    }

    public static <W extends World<W, ?>> VolumeCollector<W, BlockState, Boolean> applyBlocksToWorld(W world) {
        return VolumeCollectors.applyBlocksToWorld(world, BlockChangeFlags.ALL);
    }

    public static <W extends World<W, ?>> VolumeCollector<W, BlockEntity, Boolean> applyBlockEntityToWorld(W world) {
        return VolumeCollectors.of(world, VolumePositionTranslators.identity(), VolumeApplicators.applyBlockEntities());
    }

    public static <W extends World<W, ?>> VolumeCollector<W, Optional<? extends BlockEntity>, Boolean> applyBlockEntitiesOrRemove(W world) {
        return VolumeCollectors.of(world, VolumePositionTranslators.identity(), VolumeApplicators.applyOrRemoveBlockEntities());
    }

    public static <W extends World<W, ?>> VolumeCollector<W, Entity, Boolean> applyEntitiesToWorld(W world) {
        return VolumeCollectors.of(world, VolumePositionTranslators.identity(), VolumeApplicators.applyEntities());
    }

    public static <W extends World<W, ? extends ServerLocation>> VolumeCollector<W, EntityArchetype, Optional<? extends Entity>> applyEntityArchetypesToWorld(W world) {
        return VolumeCollectors.of(world, VolumePositionTranslators.identity(), VolumeApplicators.applyEntityArchetype());
    }

    public static <W extends World<W, ? extends ServerLocation>> VolumeCollector<W, BlockEntityArchetype, Optional<? extends BlockEntity>> applyBlockEntityArchetypesToWorld(W world) {
        return VolumeCollectors.of(world, VolumePositionTranslators.identity(), VolumeApplicators.applyBlockEntityArchetype());
    }

    public static <M extends MutableVolume, T, R> VolumeCollector<M, T, R> of(M volume, final VolumePositionTranslator<M, T> transformer, final VolumeApplicator<M, T, R> applicator) {
        WeakReference volumeRef = new WeakReference(Objects.requireNonNull(volume, "Volume cannot be null!"));
        final Supplier<MutableVolume> volumeSupplier = () -> (MutableVolume)Objects.requireNonNull(volumeRef.get(), "Target volume de-referenced");
        Objects.requireNonNull(applicator, "VolumeApplicator cannot be null");
        return new VolumeCollector<M, T, R>(){

            @Override
            public Supplier<M> target() {
                return volumeSupplier;
            }

            @Override
            public VolumePositionTranslator<M, T> positionTransform() {
                return transformer;
            }

            @Override
            public VolumeApplicator<M, T, R> applicator() {
                return applicator;
            }
        };
    }

    private VolumeCollectors() {
    }
}

