/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api;

import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.plugin.PluginContainer;

public interface ResourceKey
extends Key {
    public static final String BRIGADIER_NAMESPACE = "brigadier";
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    public static final String SPONGE_NAMESPACE = "sponge";

    public static @NonNull ResourceKey brigadier(String value) {
        return ResourceKey.of(BRIGADIER_NAMESPACE, value);
    }

    public static @NonNull ResourceKey minecraft(String value) {
        return ResourceKey.of(MINECRAFT_NAMESPACE, value);
    }

    public static @NonNull ResourceKey sponge(String value) {
        return ResourceKey.of(SPONGE_NAMESPACE, value);
    }

    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static ResourceKey of(String namespace, String value) {
        return Sponge.game().factoryProvider().provide(Factory.class).of(Objects.requireNonNull(namespace, "mamespace"), Objects.requireNonNull(value, "value"));
    }

    public static ResourceKey of(PluginContainer plugin, String value) {
        return Sponge.game().factoryProvider().provide(Factory.class).of(Objects.requireNonNull(plugin, "plugin"), Objects.requireNonNull(value, "value"));
    }

    public static ResourceKey resolve(String formatted) {
        return Sponge.game().factoryProvider().provide(Factory.class).resolve(formatted);
    }

    default public String formatted() {
        return this.asString();
    }

    default public String asString() {
        return this.namespace() + ':' + this.value();
    }

    default public int compareTo(Key o) {
        return super.compareTo(o);
    }

    public static interface Factory {
        public ResourceKey of(String var1, String var2);

        public ResourceKey of(PluginContainer var1, String var2);

        public ResourceKey resolve(String var1);
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<ResourceKey, Builder> {
        public Builder namespace(String var1);

        default public Builder namespace(PluginContainer container) {
            return this.namespace(container.getMetadata().getId());
        }

        public Builder value(String var1);

        public ResourceKey build() throws IllegalStateException;
    }
}

