/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.block.transaction;

import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.registry.RegistryTypes;

public final class BlockTransactionReceipt
implements DataSerializable {
    private final BlockSnapshot originalBlock;
    private final BlockSnapshot finalBlock;
    private final Operation operation;

    public BlockTransactionReceipt(BlockSnapshot originalBlock, BlockSnapshot finalBlock, Operation operation) {
        this.originalBlock = originalBlock;
        this.finalBlock = finalBlock;
        this.operation = operation;
    }

    public BlockSnapshot originalBlock() {
        return this.originalBlock;
    }

    public BlockSnapshot finalBlock() {
        return this.finalBlock;
    }

    public Operation operation() {
        return this.operation;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        ResourceKey resourceKey = Sponge.game().registries().registry(RegistryTypes.OPERATION).valueKey(this.operation);
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, this.contentVersion()).set(Queries.ORIGINAL, this.originalBlock.toContainer()).set(Queries.FINAL_REPLACEMENT, this.finalBlock.toContainer()).set(Queries.BLOCK_OPERATION, resourceKey);
    }
}

