/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandExecutor;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.parameter.ArgumentReader;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.Parameter;
import org.spongepowered.api.command.parameter.managed.Flag;
import org.spongepowered.api.command.registrar.tree.ClientCompletionKeys;
import org.spongepowered.api.command.registrar.tree.CommandTreeNode;

public interface Command {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public CommandResult process(CommandCause var1, ArgumentReader.Mutable var2) throws CommandException;

    public List<String> suggestions(CommandCause var1, ArgumentReader.Mutable var2) throws CommandException;

    public boolean canExecute(CommandCause var1);

    public Optional<Component> shortDescription(CommandCause var1);

    public Optional<Component> extendedDescription(CommandCause var1);

    default public Optional<Component> help(@NonNull CommandCause cause) {
        Optional<Component> shortDesc = this.shortDescription(cause);
        Optional<Component> extended = this.extendedDescription(cause);
        if (extended.isPresent()) {
            if (shortDesc.isPresent()) {
                return Optional.of(((TextComponent.Builder)Component.text().append(new Component[]{shortDesc.get(), Component.newline(), Component.newline(), extended.get()})).build());
            }
            return extended;
        }
        return shortDesc;
    }

    public Component usage(CommandCause var1);

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Parameterized, Builder> {
        default public Builder addChild(Parameterized child, String ... keys) {
            return this.addChild(child, Arrays.asList(keys));
        }

        public Builder addChild(Parameterized var1, Iterable<String> var2);

        default public Builder addChildren(Map<? extends Iterable<String>, ? extends Parameterized> children) {
            for (Map.Entry<? extends Iterable<String>, ? extends Parameterized> child : children.entrySet()) {
                this.addChild(child.getValue(), child.getKey());
            }
            return this;
        }

        public Builder addFlag(Flag var1);

        default public Builder addFlags(Flag ... flags) {
            for (Flag flag : flags) {
                this.addFlag(flag);
            }
            return this;
        }

        default public Builder addFlags(Iterable<Flag> flags) {
            for (Flag flag : flags) {
                this.addFlag(flag);
            }
            return this;
        }

        public Builder addParameter(Parameter var1);

        default public Builder addParameters(Parameter ... parameters) {
            return this.addParameters(Arrays.asList(parameters));
        }

        default public Builder addParameters(Iterable<Parameter> parameters) {
            for (Parameter parameter : parameters) {
                this.addParameter(parameter);
            }
            return this;
        }

        public Builder executor(CommandExecutor var1);

        public Builder extendedDescription(Function<CommandCause, Optional<Component>> var1);

        default public Builder extendedDescription(@Nullable Component extendedDescription) {
            Optional<Component> text = Optional.ofNullable(extendedDescription);
            return this.extendedDescription((CommandCause cause) -> text);
        }

        public Builder shortDescription(Function<CommandCause, Optional<Component>> var1);

        default public Builder shortDescription(@Nullable Component description) {
            Optional<Component> text = Optional.ofNullable(description);
            return this.shortDescription((CommandCause cause) -> text);
        }

        public Builder permission(@Nullable String var1);

        public Builder executionRequirements(@Nullable Predicate<CommandCause> var1);

        public Builder terminal(boolean var1);

        public Parameterized build();
    }

    public static interface Parameterized
    extends Command {
        public List<Flag> flags();

        public List<Parameter> parameters();

        public List<Parameter.Subcommand> subcommands();

        public boolean isTerminal();

        public Predicate<CommandCause> executionRequirements();

        public CommandContext parseArguments(CommandCause var1, ArgumentReader.Mutable var2) throws ArgumentParseException;

        public Optional<CommandExecutor> executor();

        @Override
        default public CommandResult process(CommandCause cause, ArgumentReader.Mutable arguments) throws CommandException {
            if (this.executor().isPresent()) {
                return this.executor().get().execute(this.parseArguments(cause, arguments));
            }
            throw new CommandException((Component)Component.text((String)"This command does not have an executor!"));
        }
    }

    public static interface Raw
    extends Command {
        default public CommandTreeNode.Root commandTree() {
            return (CommandTreeNode.Root)CommandTreeNode.root().executable().child("arguments", (CommandTreeNode.Argument)((CommandTreeNode.StringParser)ClientCompletionKeys.STRING.get().createNode().greedy().executable()).customSuggestions());
        }
    }
}

