/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.parameter.managed.standard;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.parameter.CommandContext;
import org.spongepowered.api.command.parameter.managed.ValueParameter;
import org.spongepowered.api.registry.DefaultedRegistryType;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.util.Builder;

public final class VariableValueParameters {
    private VariableValueParameters() {
    }

    public static <T> RegistryEntryBuilder<T> registryEntryBuilder(Function<CommandContext, @Nullable RegistryHolder> holderProvider, RegistryType<T> registryKey) {
        return Sponge.game().factoryProvider().provide(Factory.class).createRegistryEntryBuilder(holderProvider, registryKey);
    }

    public static <T> RegistryEntryBuilder<T> registryEntryBuilder(Function<CommandContext, @Nullable ? extends Registry<? extends T>> registryProvider) {
        return Sponge.game().factoryProvider().provide(Factory.class).createRegistryEntryBuilder(registryProvider);
    }

    public static <T> RegistryEntryBuilder<T> registryEntryBuilder(DefaultedRegistryType<T> type) {
        return Sponge.game().factoryProvider().provide(Factory.class).createRegistryEntryBuilder(type);
    }

    public static <T> StaticChoicesBuilder<T> staticChoicesBuilder(Class<T> returnType) {
        return Sponge.game().factoryProvider().provide(Factory.class).createStaticChoicesBuilder(returnType);
    }

    public static <T> DynamicChoicesBuilder<T> dynamicChoicesBuilder(Class<T> returnType) {
        return Sponge.game().factoryProvider().provide(Factory.class).createDynamicChoicesBuilder(returnType);
    }

    public static <T> LiteralBuilder<T> literalBuilder(Class<T> returnType) {
        return Sponge.game().factoryProvider().provide(Factory.class).createLiteralBuilder(returnType);
    }

    public static TextBuilder textBuilder() {
        return Sponge.game().builderProvider().provide(TextBuilder.class);
    }

    public static <T extends Enum<T>> ValueParameter<T> enumChoices(Class<T> enumClass) {
        return Sponge.game().factoryProvider().provide(Factory.class).createEnumParameter(enumClass);
    }

    public static NumberRangeBuilder<Double> doubleRange() {
        return Sponge.game().factoryProvider().provide(Factory.class).createDoubleNumberRangeBuilder();
    }

    public static NumberRangeBuilder<Float> floatRange() {
        return Sponge.game().factoryProvider().provide(Factory.class).createFloatNumberRangeBuilder();
    }

    public static NumberRangeBuilder<Integer> integerRange() {
        return Sponge.game().factoryProvider().provide(Factory.class).createIntegerNumberRangeBuilder();
    }

    public static NumberRangeBuilder<Long> longRange() {
        return Sponge.game().factoryProvider().provide(Factory.class).createLongNumberRangeBuilder();
    }

    public static ValueParameter<String> validatedString(Pattern pattern) {
        return Sponge.game().factoryProvider().provide(Factory.class).createValidatedStringParameter(pattern);
    }

    public static interface Factory {
        public <T extends Enum<T>> ValueParameter<T> createEnumParameter(Class<T> var1);

        public <T> StaticChoicesBuilder<T> createStaticChoicesBuilder(Class<T> var1);

        public <T> DynamicChoicesBuilder<T> createDynamicChoicesBuilder(Class<T> var1);

        public <T> RegistryEntryBuilder<T> createRegistryEntryBuilder(Function<CommandContext, @Nullable RegistryHolder> var1, RegistryType<T> var2);

        public <T> RegistryEntryBuilder<T> createRegistryEntryBuilder(Function<CommandContext, @Nullable ? extends Registry<? extends T>> var1);

        public <T> RegistryEntryBuilder<T> createRegistryEntryBuilder(DefaultedRegistryType<T> var1);

        public <T> LiteralBuilder<T> createLiteralBuilder(Class<T> var1);

        public NumberRangeBuilder<Integer> createIntegerNumberRangeBuilder();

        public NumberRangeBuilder<Float> createFloatNumberRangeBuilder();

        public NumberRangeBuilder<Double> createDoubleNumberRangeBuilder();

        public NumberRangeBuilder<Long> createLongNumberRangeBuilder();

        public ValueParameter<String> createValidatedStringParameter(Pattern var1);
    }

    public static interface NumberRangeBuilder<T extends Number>
    extends Builder<ValueParameter<T>, NumberRangeBuilder<T>> {
        public NumberRangeBuilder<T> min(T var1);

        public NumberRangeBuilder<T> max(T var1);

        public ValueParameter<T> build();
    }

    public static interface TextBuilder
    extends Builder<ValueParameter<Component>, TextBuilder> {
        public TextBuilder serializer(ComponentSerializer<Component, ? extends Component, String> var1);

        public TextBuilder serializerSupplier(Supplier<ComponentSerializer<Component, ? extends Component, String>> var1);

        public TextBuilder consumeAllArguments(boolean var1);

        public ValueParameter<Component> build() throws IllegalStateException;
    }

    public static interface LiteralBuilder<T>
    extends Builder<ValueParameter<T>, LiteralBuilder<T>> {
        public LiteralBuilder<T> literal(Supplier<? extends Collection<String>> var1);

        default public LiteralBuilder<T> literal(Collection<String> literal) {
            return this.literal(() -> literal);
        }

        public LiteralBuilder<T> returnValue(Supplier<T> var1);

        default public LiteralBuilder<T> returnValue(T returnValue) {
            return this.returnValue((T)((Supplier<Object>)() -> returnValue));
        }

        public ValueParameter<T> build();
    }

    public static interface DynamicChoicesBuilder<T>
    extends Builder<ValueParameter<T>, DynamicChoicesBuilder<T>> {
        public DynamicChoicesBuilder<T> choicesAndResults(Supplier<Map<String, ? extends T>> var1);

        public DynamicChoicesBuilder<T> choices(Supplier<? extends Collection<String>> var1);

        public DynamicChoicesBuilder<T> results(Function<String, ? extends T> var1);

        public DynamicChoicesBuilder<T> showInUsage(boolean var1);

        public ValueParameter<T> build();
    }

    public static interface StaticChoicesBuilder<T>
    extends Builder<ValueParameter<T>, StaticChoicesBuilder<T>> {
        default public StaticChoicesBuilder<T> addChoice(String choice, T returnedObject) {
            return this.addChoices(Collections.singleton(choice), () -> returnedObject);
        }

        default public StaticChoicesBuilder<T> addChoices(Map<String, ? extends T> choices) {
            for (Map.Entry<String, T> entry : choices.entrySet()) {
                this.addChoice(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public StaticChoicesBuilder<T> addChoices(Iterable<String> var1, Supplier<? extends T> var2);

        public StaticChoicesBuilder<T> showInUsage(boolean var1);

        public ValueParameter<T> build();
    }

    public static interface RegistryEntryBuilder<T>
    extends Builder<ValueParameter<T>, RegistryEntryBuilder<T>> {
        public static final Function<CommandContext, @Nullable RegistryHolder> GLOBAL_HOLDER_PROVIDER = in -> Sponge.game().registries();
        public static final Function<CommandContext, @Nullable RegistryHolder> SERVER_HOLDER_PROVIDER = in -> {
            try {
                return Sponge.game().server().registries();
            }
            catch (IllegalStateException ignored) {
                return null;
            }
        };

        public RegistryEntryBuilder<T> defaultNamespace(String var1);

        public ValueParameter<T> build();
    }
}

