/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.effect.particle;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.math.vector.Vector3d;

public interface ParticleEffect
extends DataSerializable {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public ParticleType type();

    default public <V> Optional<V> option(Supplier<? extends ParticleOption<V>> option) {
        return this.option(option.get());
    }

    public <V> Optional<V> option(ParticleOption<V> var1);

    default public <V> Optional<V> optionOrDefault(Supplier<? extends ParticleOption<V>> option) {
        return this.optionOrDefault(option.get());
    }

    default public <V> Optional<V> optionOrDefault(ParticleOption<V> option) {
        Optional<V> value = this.option(option);
        return value.isPresent() ? value : this.type().defaultOption(option);
    }

    public Map<ParticleOption<?>, Object> options();

    public static interface Builder
    extends org.spongepowered.api.util.Builder<ParticleEffect, Builder>,
    CopyableBuilder<ParticleEffect, Builder>,
    DataBuilder<ParticleEffect> {
        public Builder type(ParticleType var1);

        default public Builder type(Supplier<? extends ParticleType> particleType) {
            return this.type(particleType.get());
        }

        public <V> Builder option(ParticleOption<V> var1, V var2) throws IllegalArgumentException;

        default public <V> Builder option(Supplier<? extends ParticleOption<V>> option, V value) throws IllegalArgumentException {
            return this.option(option.get(), value);
        }

        default public Builder velocity(Vector3d velocity) {
            return this.option(ParticleOptions.VELOCITY, velocity);
        }

        default public Builder offset(Vector3d offset) {
            return this.option(ParticleOptions.OFFSET, offset);
        }

        default public Builder quantity(int quantity) throws IllegalArgumentException {
            return this.option(ParticleOptions.QUANTITY, Integer.valueOf(quantity));
        }

        public ParticleEffect build();
    }
}

