/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.enchantment;

import java.util.List;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.CopyableBuilder;

public interface Enchantment
extends DataSerializable {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static RandomListBuilder randomListBuilder() {
        return Sponge.game().builderProvider().provide(RandomListBuilder.class);
    }

    public static Enchantment of(Supplier<? extends EnchantmentType> enchantmentType, int level) throws IllegalArgumentException {
        return Enchantment.of(enchantmentType.get(), level);
    }

    public static Enchantment of(EnchantmentType enchantmentType, int level) throws IllegalArgumentException {
        return Enchantment.builder().type(enchantmentType).level(level).build();
    }

    public EnchantmentType type();

    public int level();

    public static interface RandomListBuilder
    extends org.spongepowered.api.util.Builder<List<Enchantment>, RandomListBuilder> {
        public RandomListBuilder seed(int var1);

        public RandomListBuilder option(int var1);

        public RandomListBuilder level(int var1);

        public RandomListBuilder treasure(boolean var1);

        public RandomListBuilder fixedPool(List<Enchantment> var1);

        public RandomListBuilder item(ItemStack var1);

        public List<Enchantment> build() throws IllegalStateException;
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Enchantment, Builder>,
    CopyableBuilder<Enchantment, Builder>,
    DataBuilder<Enchantment> {
        public Builder type(EnchantmentType var1);

        default public Builder type(Supplier<? extends EnchantmentType> enchantmentType) {
            return this.type(enchantmentType.get());
        }

        public Builder level(int var1) throws IllegalArgumentException;

        public Enchantment build() throws IllegalStateException;
    }
}

