/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.query.Query;
import org.spongepowered.api.item.inventory.query.QueryType;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.ViewableInventory;

public interface Inventory
extends ValueContainer {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public Inventory parent();

    public Inventory root();

    public List<Slot> slots();

    public List<Inventory> children();

    public boolean hasChildren();

    public InventoryTransactionResult.Poll poll();

    public InventoryTransactionResult.Poll poll(int var1);

    public ItemStack peek();

    public InventoryTransactionResult offer(ItemStack ... var1);

    public boolean canFit(ItemStack var1);

    public InventoryTransactionResult.Poll pollFrom(int var1);

    public InventoryTransactionResult.Poll pollFrom(int var1, int var2);

    public Optional<ItemStack> peekAt(int var1);

    public InventoryTransactionResult offer(int var1, ItemStack var2);

    public InventoryTransactionResult set(int var1, ItemStack var2);

    public Optional<Slot> slot(int var1);

    public void clear();

    public int freeCapacity();

    public int totalQuantity();

    public int capacity();

    public boolean contains(ItemStack var1);

    public boolean contains(ItemType var1);

    public boolean containsAny(ItemStack var1);

    public <V> Optional<V> get(Inventory var1, Key<? extends Value<V>> var2);

    public <V> Optional<V> get(Key<? extends Value<V>> var1);

    public Inventory query(Query var1);

    default public <P> Inventory query(Supplier<QueryType.OneParam<P>> queryType, P param) {
        return this.query(queryType.get().of(param));
    }

    default public <P> Inventory query(Supplier<QueryType.OneParam<P>> queryType, Supplier<P> param) {
        return this.query(queryType.get().of(param.get()));
    }

    default public <P1, P2> Inventory query(Supplier<QueryType.TwoParam<P1, P2>> queryType, P1 param1, P2 param2) {
        return this.query(queryType.get().of(param1, param2));
    }

    default public Inventory query(KeyValueMatcher<?> matcher) {
        return this.query(QueryTypes.KEY_VALUE.get().of(matcher));
    }

    public <T extends Inventory> Optional<T> query(Class<T> var1);

    public Inventory intersect(Inventory var1);

    public Inventory union(Inventory var1);

    public boolean containsInventory(Inventory var1);

    public boolean containsChild(Inventory var1);

    public Optional<ViewableInventory> asViewable();

    public static interface Builder
    extends org.spongepowered.api.util.Builder<Inventory, Builder> {
        public BuildingStep slots(int var1);

        public BuildingStep grid(int var1, int var2);

        public BuildingStep inventory(Inventory var1);

        public static interface EndStep {
            public EndStep identity(UUID var1);

            public EndStep carrier(Carrier var1);

            public Inventory build();
        }

        public static interface BuildingStep
        extends Builder {
            public EndStep completeStructure();
        }
    }
}

