/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataHolderBuilder;
import org.spongepowered.api.data.SerializableDataHolder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.registry.DefaultedRegistryReference;

public interface ItemStack
extends SerializableDataHolder.Mutable {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static ItemStack of(Supplier<? extends ItemType> itemType, int quantity) {
        return ItemStack.of(itemType.get(), quantity);
    }

    public static ItemStack of(ItemType itemType, int quantity) {
        return ItemStack.builder().itemType(itemType).quantity(quantity).build();
    }

    public static ItemStack of(Supplier<? extends ItemType> itemType) {
        return ItemStack.of(itemType.get());
    }

    public static ItemStack of(ItemType itemType) {
        return ItemStack.of(itemType, 1);
    }

    public static ItemStack empty() {
        return ItemStack.builder().itemType(ItemTypes.AIR).build();
    }

    public ItemType type();

    public int quantity();

    public void setQuantity(int var1) throws IllegalArgumentException;

    public int maxStackQuantity();

    public ItemStackSnapshot createSnapshot();

    public boolean equalTo(ItemStack var1);

    public boolean isEmpty();

    default public Collection<AttributeModifier> attributeModifiers(Supplier<? extends AttributeType> attributeType, DefaultedRegistryReference<? extends EquipmentType> equipmentType) {
        return this.attributeModifiers(attributeType.get(), equipmentType.get());
    }

    default public Collection<AttributeModifier> attributeModifiers(AttributeType attributeType, DefaultedRegistryReference<? extends EquipmentType> equipmentType) {
        return this.attributeModifiers(attributeType, equipmentType.get());
    }

    default public Collection<AttributeModifier> attributeModifiers(Supplier<? extends AttributeType> attributeType, EquipmentType equipmentType) {
        return this.attributeModifiers(attributeType.get(), equipmentType);
    }

    public Collection<AttributeModifier> attributeModifiers(AttributeType var1, EquipmentType var2);

    default public void addAttributeModifier(Supplier<? extends AttributeType> attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
        this.addAttributeModifier(attributeType.get(), modifier, equipmentType);
    }

    default public void addAttributeModifier(AttributeType attributeType, AttributeModifier modifier, DefaultedRegistryReference<? extends EquipmentType> equipmentType) {
        this.addAttributeModifier(attributeType, modifier, equipmentType.get());
    }

    default public void addAttributeModifier(Supplier<? extends AttributeType> attributeType, AttributeModifier modifier, DefaultedRegistryReference<? extends EquipmentType> equipmentType) {
        this.addAttributeModifier(attributeType.get(), modifier, equipmentType.get());
    }

    public void addAttributeModifier(AttributeType var1, AttributeModifier var2, EquipmentType var3);

    @Override
    public ItemStack copy();

    public static interface Builder
    extends DataHolderBuilder.Mutable<ItemStack, Builder> {
        public Builder itemType(ItemType var1);

        default public Builder itemType(Supplier<? extends ItemType> itemType) {
            return this.itemType(itemType.get());
        }

        public ItemType currentItem();

        public Builder quantity(int var1) throws IllegalArgumentException;

        public Builder fromItemStack(ItemStack var1);

        default public Builder attributeModifier(Supplier<? extends AttributeType> attributeType, AttributeModifier modifier, DefaultedRegistryReference<? extends EquipmentType> equipmentType) {
            return this.attributeModifier(attributeType.get(), modifier, equipmentType.get());
        }

        public Builder attributeModifier(AttributeType var1, AttributeModifier var2, EquipmentType var3);

        public Builder fromBlockState(BlockState var1);

        default public Builder fromBlockState(Supplier<? extends BlockState> blockState) {
            Objects.requireNonNull(blockState, "blockState");
            return this.fromBlockState(blockState.get());
        }

        public Builder fromContainer(DataView var1);

        default public Builder fromSnapshot(ItemStackSnapshot snapshot) {
            return this.fromItemStack(snapshot.createStack());
        }

        public Builder fromBlockSnapshot(BlockSnapshot var1);

        default public Builder apply(Predicate<Builder> predicate, Consumer<Builder> consumer) {
            if (predicate.test(this)) {
                consumer.accept(this);
            }
            return this;
        }

        public ItemStack build() throws IllegalStateException;
    }
}

