/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.map;

import java.awt.Color;
import java.awt.Image;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataSerializable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.map.color.MapColor;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.math.vector.Vector2i;

public interface MapCanvas
extends DataSerializable {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public static MapCanvas blank() {
        return MapCanvas.builder().build();
    }

    public MapColor color(int var1, int var2) throws IllegalArgumentException;

    public Image toImage();

    public Image toImage(Color var1);

    public Builder toBuilder();

    public static interface Builder
    extends ResettableBuilder<MapCanvas, Builder> {
        public Builder paintAll(MapColor var1);

        public Builder paint(int var1, int var2, int var3, int var4, MapColor var5);

        default public Builder paint(Vector2i start, Vector2i end, MapColor mapColor) {
            return this.paint(Math.min(start.getX(), end.getX()), Math.max(start.getX(), end.getX()), Math.min(start.getY(), end.getY()), Math.min(start.getY(), end.getY()), mapColor);
        }

        public Builder from(MapCanvas var1);

        public Builder fromImage(Image var1) throws IllegalArgumentException;

        public Builder fromContainer(DataView var1);

        public MapCanvas build();
    }
}

