/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.permission;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.NodeTree;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;

public class MemorySubjectData
implements SubjectData {
    protected final Subject subject;
    protected final ConcurrentMap<Set<Context>, Map<String, String>> options = Maps.newConcurrentMap();
    protected final ConcurrentMap<Set<Context>, NodeTree> permissions = Maps.newConcurrentMap();
    protected final ConcurrentMap<Set<Context>, List<SubjectReference>> parents = Maps.newConcurrentMap();

    public MemorySubjectData(Subject subject) {
        this.subject = Objects.requireNonNull(subject, "subject");
    }

    protected void onUpdate() {
    }

    @Override
    public Subject subject() {
        return this.subject;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public Map<Set<Context>, Map<String, Boolean>> allPermissions() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry ent : this.permissions.entrySet()) {
            ret.put(ent.getKey(), ((NodeTree)ent.getValue()).asMap());
        }
        return ret.build();
    }

    public NodeTree nodeTree(Set<Context> contexts) {
        NodeTree perms = (NodeTree)this.permissions.get(Objects.requireNonNull(contexts, "contexts"));
        return perms == null ? NodeTree.of((Map<String, Boolean>)ImmutableMap.of()) : perms;
    }

    @Override
    public Map<String, Boolean> permissions(Set<Context> contexts) {
        NodeTree perms = (NodeTree)this.permissions.get(Objects.requireNonNull(contexts, "contexts"));
        return perms == null ? ImmutableMap.of() : perms.asMap();
    }

    @Override
    public CompletableFuture<Boolean> setPermission(Set<Context> contexts, String permission, Tristate value) {
        NodeTree oldTree;
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(permission, "permission");
        Objects.requireNonNull(value, "value");
        contexts = ImmutableSet.copyOf(contexts);
        do {
            if ((oldTree = (NodeTree)this.permissions.get(contexts)) == null || oldTree.get(permission) != value) continue;
            return CompletableFuture.completedFuture(false);
        } while (!(oldTree == null && value != Tristate.UNDEFINED ? this.permissions.putIfAbsent((Set<Context>)contexts, NodeTree.of((Map<String, Boolean>)ImmutableMap.of((Object)permission, (Object)value.asBoolean()))) == null : oldTree == null || this.permissions.replace((Set<Context>)contexts, oldTree, oldTree.withValue(permission, value))));
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions() {
        boolean wasEmpty = this.permissions.isEmpty();
        this.permissions.clear();
        if (!wasEmpty) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(!wasEmpty);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions(Set<Context> context) {
        boolean ret;
        boolean bl = ret = this.permissions.remove(Objects.requireNonNull(context, "context")) != null;
        if (ret) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(ret);
    }

    @Override
    public Map<Set<Context>, List<SubjectReference>> allParents() {
        return ImmutableMap.copyOf(this.parents);
    }

    @Override
    public List<SubjectReference> parents(Set<Context> contexts) {
        return this.parents.getOrDefault(Objects.requireNonNull(contexts, "contexts"), (List<SubjectReference>)ImmutableList.of());
    }

    @Override
    public CompletableFuture<Boolean> addParent(Set<Context> contexts, SubjectReference parent) {
        ImmutableList newParents;
        List oldParents;
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(parent, "parent");
        contexts = ImmutableSet.copyOf(contexts);
        do {
            if ((oldParents = (List)this.parents.get(contexts)) == null || !oldParents.contains(parent)) continue;
            return CompletableFuture.completedFuture(false);
        } while (!this.updateCollection(this.parents, contexts, oldParents, newParents = ImmutableList.builder().addAll((Iterable)(oldParents == null ? ImmutableList.of() : oldParents)).add((Object)parent).build()));
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    private <K, V> boolean updateCollection(ConcurrentMap<K, V> collection, K key, @Nullable V oldValue, V newValue) {
        if (oldValue == null) {
            return collection.putIfAbsent(key, newValue) == null;
        }
        return collection.replace(key, oldValue, newValue);
    }

    @Override
    public CompletableFuture<Boolean> removeParent(Set<Context> contexts, SubjectReference parent) {
        ArrayList newParents;
        List oldParents;
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(parent, "parent");
        contexts = ImmutableSet.copyOf(contexts);
        do {
            if ((oldParents = (List)this.parents.get(contexts)) == null || !oldParents.contains(parent)) {
                return CompletableFuture.completedFuture(false);
            }
            newParents = new ArrayList(oldParents);
            newParents.remove(parent);
        } while (!this.updateCollection(this.parents, contexts, oldParents, ImmutableList.copyOf(newParents)));
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearParents() {
        boolean wasEmpty = this.parents.isEmpty();
        this.parents.clear();
        if (!wasEmpty) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(!wasEmpty);
    }

    @Override
    public CompletableFuture<Boolean> clearParents(Set<Context> contexts) {
        boolean ret;
        boolean bl = ret = this.parents.remove(Objects.requireNonNull(contexts, "contexts")) != null;
        if (ret) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(ret);
    }

    @Override
    public Map<Set<Context>, Map<String, String>> allOptions() {
        return ImmutableMap.copyOf(this.options);
    }

    @Override
    public Map<String, String> options(Set<Context> contexts) {
        return this.options.getOrDefault(Objects.requireNonNull(contexts, "contexts"), (Map<String, String>)ImmutableMap.of());
    }

    @Override
    public CompletableFuture<Boolean> setOption(Set<Context> contexts, String key, @Nullable String value) {
        ImmutableMap newMap;
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(key, "key");
        Map<String, String> origMap = (Map<String, String>)this.options.get(contexts);
        if (origMap == null) {
            if (value == null) {
                return CompletableFuture.completedFuture(false);
            }
            origMap = this.options.putIfAbsent((Set<Context>)ImmutableSet.copyOf(contexts), (Map<String, String>)ImmutableMap.of((Object)key.toLowerCase(), (Object)value));
            if (origMap == null) {
                this.onUpdate();
                return CompletableFuture.completedFuture(true);
            }
        }
        do {
            if (value == null) {
                if (!origMap.containsKey(key)) {
                    return CompletableFuture.completedFuture(false);
                }
                newMap = new HashMap(origMap);
                newMap.remove(key);
                continue;
            }
            newMap = new HashMap(origMap);
            newMap.put(key, value);
        } while (!this.options.replace(contexts, origMap, (Map<String, String>)(newMap = ImmutableMap.copyOf(newMap))));
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions() {
        boolean wasEmpty = this.options.isEmpty();
        this.options.clear();
        if (!wasEmpty) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(!wasEmpty);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions(Set<Context> contexts) {
        boolean ret;
        boolean bl = ret = this.options.remove(Objects.requireNonNull(contexts, "contexts")) != null;
        if (ret) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(ret);
    }
}

