/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.permission;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;

public interface SubjectCollection {
    public String identifier();

    public Predicate<String> identifierValidityPredicate();

    public CompletableFuture<Subject> loadSubject(String var1);

    public Optional<Subject> subject(String var1);

    public CompletableFuture<Boolean> hasSubject(String var1);

    public CompletableFuture<Map<String, Subject>> loadSubjects(Set<String> var1);

    public Collection<Subject> loadedSubjects();

    public CompletableFuture<Set<String>> allIdentifiers();

    public SubjectReference newSubjectReference(String var1);

    default public CompletableFuture<Void> applyToAll(Consumer<Subject> action) {
        Objects.requireNonNull(action, "action");
        return CompletableFuture.runAsync(() -> {
            Set<String> identifiers = this.allIdentifiers().join();
            this.applyToAll(action, identifiers).join();
        });
    }

    default public CompletableFuture<Void> applyToAll(Consumer<Subject> action, Set<String> identifiers) {
        Objects.requireNonNull(action, "action");
        Objects.requireNonNull(identifiers, "identifiers");
        return CompletableFuture.runAsync(() -> {
            for (String id : identifiers) {
                Subject subject = this.loadSubject(id).join();
                action.accept(subject);
                this.suggestUnload(subject.identifier());
            }
        });
    }

    public CompletableFuture<Map<SubjectReference, Boolean>> allWithPermission(String var1);

    public CompletableFuture<Map<SubjectReference, Boolean>> allWithPermission(Set<Context> var1, String var2);

    public Map<Subject, Boolean> loadedWithPermission(String var1);

    public Map<Subject, Boolean> loadedWithPermission(Set<Context> var1, String var2);

    public Subject defaults();

    public void suggestUnload(String var1);
}

