/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface AABB {
    public static AABB of(Vector3d v1, Vector3d v2) {
        return Sponge.game().factoryProvider().provide(Factory.class).create(v1, v2);
    }

    public static AABB of(Vector3i v1, Vector3i v2) {
        return AABB.of(Objects.requireNonNull(v1, "v1").toDouble(), Objects.requireNonNull(v2, "v2").toDouble());
    }

    public static AABB of(double x1, double y1, double z1, double x2, double y2, double z2) {
        return AABB.of(new Vector3d(x1, y1, z1), new Vector3d(x2, y2, z2));
    }

    public Vector3d min();

    public Vector3d max();

    public Vector3d center();

    public Vector3d size();

    default public boolean contains(Vector3i point) {
        Objects.requireNonNull(point, "point");
        return this.contains(point.getX(), point.getY(), point.getZ());
    }

    default public boolean contains(Vector3d point) {
        Objects.requireNonNull(point, "point");
        return this.contains(point.getX(), point.getY(), point.getZ());
    }

    public boolean contains(double var1, double var3, double var5);

    public boolean intersects(AABB var1);

    public Optional<Tuple<Vector3d, Vector3d>> intersects(Vector3d var1, Vector3d var2);

    default public AABB offset(Vector3i offset) {
        Objects.requireNonNull(offset, "offset");
        return this.offset(offset.getX(), offset.getY(), offset.getZ());
    }

    default public AABB offset(Vector3d offset) {
        Objects.requireNonNull(offset, "offset");
        return this.offset(offset.getX(), offset.getY(), offset.getZ());
    }

    public AABB offset(double var1, double var3, double var5);

    default public AABB expand(Vector3i amount) {
        Objects.requireNonNull(amount, "amount");
        return this.expand(amount.getX(), amount.getY(), amount.getZ());
    }

    default public AABB expand(Vector3d amount) {
        Objects.requireNonNull(amount, "amount");
        return this.expand(amount.getX(), amount.getY(), amount.getZ());
    }

    public AABB expand(double var1, double var3, double var5);

    public static interface Factory {
        public AABB create(Vector3d var1, Vector3d var2);
    }
}

