/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.AxisDirection;
import org.spongepowered.math.GenericMath;
import org.spongepowered.math.TrigMath;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public enum Direction {
    NORTH(new Vector3d(0.0f, 0.0f, -1.0f), Division.CARDINAL),
    NORTH_NORTHEAST(new Vector3d(C.S8, 0.0, -C.C8), Division.SECONDARY_ORDINAL),
    NORTHEAST(new Vector3d(1.0f, 0.0f, -1.0f), Division.ORDINAL),
    EAST_NORTHEAST(new Vector3d(C.C8, 0.0, -C.S8), Division.SECONDARY_ORDINAL),
    EAST(new Vector3d(1.0f, 0.0f, 0.0f), Division.CARDINAL),
    EAST_SOUTHEAST(new Vector3d(C.C8, 0.0, C.S8), Division.SECONDARY_ORDINAL),
    SOUTHEAST(new Vector3d(1.0f, 0.0f, 1.0f), Division.ORDINAL),
    SOUTH_SOUTHEAST(new Vector3d(C.S8, 0.0, C.C8), Division.SECONDARY_ORDINAL),
    SOUTH(new Vector3d(0.0f, 0.0f, 1.0f), Division.CARDINAL),
    SOUTH_SOUTHWEST(new Vector3d(-C.S8, 0.0, C.C8), Division.SECONDARY_ORDINAL),
    SOUTHWEST(new Vector3d(-1.0f, 0.0f, 1.0f), Division.ORDINAL),
    WEST_SOUTHWEST(new Vector3d(-C.C8, 0.0, C.S8), Division.SECONDARY_ORDINAL),
    WEST(new Vector3d(-1.0f, 0.0f, 0.0f), Division.CARDINAL),
    WEST_NORTHWEST(new Vector3d(-C.C8, 0.0, -C.S8), Division.SECONDARY_ORDINAL),
    NORTHWEST(new Vector3d(-1.0f, 0.0f, -1.0f), Division.ORDINAL),
    NORTH_NORTHWEST(new Vector3d(-C.S8, 0.0, -C.C8), Division.SECONDARY_ORDINAL),
    UP(new Vector3d(0.0f, 1.0f, 0.0f), Division.CARDINAL),
    DOWN(new Vector3d(0.0f, -1.0f, 0.0f), Division.CARDINAL),
    NONE(new Vector3d(0.0f, 0.0f, 0.0f), Division.NONE);

    private static final Direction[] SECONDARY_ORDINAL_SET;
    private static final Direction[] ORDINAL_SET;
    private static final Direction[] CARDINAL_SET;
    private final Vector3d offset;
    private final Vector3i blockOffset;
    private final Division division;
    private Direction opposite;

    private Direction(Vector3d direction, Division division) {
        this.offset = direction.lengthSquared() == 0.0 ? direction : direction.normalize();
        this.blockOffset = direction.round().toInt();
        this.division = division;
    }

    public static Direction closest(Vector3d vector) {
        return Direction.closest(vector, Division.SECONDARY_ORDINAL);
    }

    public static Direction closest(Vector3d vector, Division smallestDivision) {
        if (vector.getY() * vector.getY() <= vector.getX() * vector.getX() + vector.getZ() * vector.getZ()) {
            return Direction.closestHorizontal(vector, smallestDivision);
        }
        if (vector.getY() > 0.0) {
            return UP;
        }
        return DOWN;
    }

    public static Direction closestHorizontal(Vector3d vector) {
        return Direction.closestHorizontal(vector, Division.SECONDARY_ORDINAL);
    }

    public static Direction closestHorizontal(Vector3d vector, Division smallestDivision) {
        Direction[] set;
        if (Math.abs(vector.getX()) <= GenericMath.DBL_EPSILON && Math.abs(vector.getZ()) <= GenericMath.DBL_EPSILON) {
            return NONE;
        }
        vector = vector.normalize();
        double angle = TrigMath.acos((double)vector.getX());
        if (vector.getZ() < 0.0) {
            angle = Math.PI * 2 - angle;
        }
        angle = (angle + Math.PI * 2 + 1.5707963267948966) % (Math.PI * 2);
        switch (smallestDivision) {
            case CARDINAL: {
                set = CARDINAL_SET;
                break;
            }
            case ORDINAL: {
                set = ORDINAL_SET;
                break;
            }
            case SECONDARY_ORDINAL: {
                set = SECONDARY_ORDINAL_SET;
                break;
            }
            default: {
                throw new IllegalArgumentException(smallestDivision.name());
            }
        }
        return set[(int)Math.round(angle * (double)set.length / (Math.PI * 2)) % set.length];
    }

    public static Direction fromAxis(Axis axis) {
        switch (axis) {
            case X: {
                return EAST;
            }
            case Y: {
                return UP;
            }
            case Z: {
                return SOUTH;
            }
        }
        throw new IllegalArgumentException(axis.name());
    }

    public static Direction fromAxis(Axis axis, AxisDirection direction) {
        switch (direction) {
            case PLUS: {
                return Direction.fromAxis(axis);
            }
            case ZERO: {
                return NONE;
            }
            case MINUS: {
                return Direction.fromAxis(axis).opposite();
            }
        }
        throw new IllegalArgumentException(axis.name());
    }

    public Direction opposite() {
        return this.opposite;
    }

    public boolean isOpposite(Direction d) {
        return this.opposite == d;
    }

    public boolean isCardinal() {
        return this.division == Division.CARDINAL;
    }

    public boolean isOrdinal() {
        return this.division == Division.ORDINAL;
    }

    public boolean isSecondaryOrdinal() {
        return this.division == Division.SECONDARY_ORDINAL;
    }

    public boolean isUpright() {
        return this == UP || this == DOWN;
    }

    public Vector3d asOffset() {
        return this.offset;
    }

    public Vector3i asBlockOffset() {
        return this.blockOffset;
    }

    static {
        SECONDARY_ORDINAL_SET = new Direction[]{NORTH, NORTH_NORTHEAST, NORTHEAST, EAST_NORTHEAST, EAST, EAST_SOUTHEAST, SOUTHEAST, SOUTH_SOUTHEAST, SOUTH, SOUTH_SOUTHWEST, SOUTHWEST, WEST_SOUTHWEST, WEST, WEST_NORTHWEST, NORTHWEST, NORTH_NORTHWEST};
        ORDINAL_SET = new Direction[]{NORTH, NORTHEAST, EAST, SOUTHEAST, SOUTH, SOUTHWEST, WEST, NORTHWEST};
        CARDINAL_SET = new Direction[]{NORTH, EAST, SOUTH, WEST};
        Direction.NORTH.opposite = SOUTH;
        Direction.EAST.opposite = WEST;
        Direction.SOUTH.opposite = NORTH;
        Direction.WEST.opposite = EAST;
        Direction.UP.opposite = DOWN;
        Direction.DOWN.opposite = UP;
        Direction.NONE.opposite = NONE;
        Direction.NORTHEAST.opposite = SOUTHWEST;
        Direction.NORTHWEST.opposite = SOUTHEAST;
        Direction.SOUTHEAST.opposite = NORTHWEST;
        Direction.SOUTHWEST.opposite = NORTHEAST;
        Direction.WEST_NORTHWEST.opposite = EAST_SOUTHEAST;
        Direction.WEST_SOUTHWEST.opposite = EAST_NORTHEAST;
        Direction.NORTH_NORTHWEST.opposite = SOUTH_SOUTHEAST;
        Direction.NORTH_NORTHEAST.opposite = SOUTH_SOUTHWEST;
        Direction.EAST_SOUTHEAST.opposite = WEST_NORTHWEST;
        Direction.EAST_NORTHEAST.opposite = WEST_SOUTHWEST;
        Direction.SOUTH_SOUTHEAST.opposite = NORTH_NORTHWEST;
        Direction.SOUTH_SOUTHWEST.opposite = NORTH_NORTHEAST;
    }

    public static enum Division {
        CARDINAL,
        ORDINAL,
        SECONDARY_ORDINAL,
        NONE;

    }

    private static interface C {
        public static final double C8 = Math.cos(0.39269908169872414);
        public static final double S8 = Math.sin(0.39269908169872414);
    }
}

