/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import java.util.Arrays;
import java.util.Optional;
import org.spongepowered.math.GenericMath;
import org.spongepowered.math.imaginary.Complexd;
import org.spongepowered.math.matrix.Matrix3d;
import org.spongepowered.math.vector.Vector2d;
import org.spongepowered.math.vector.Vector2i;
import org.spongepowered.math.vector.Vector3d;

public class DiscreteTransform2 {
    public static final DiscreteTransform2 IDENTITY = new DiscreteTransform2(Matrix3d.IDENTITY);
    private final Matrix3d matrix;
    private final Vector3d matrixRow0;
    private final Vector3d matrixRow1;

    private DiscreteTransform2(Matrix3d matrix) {
        this.matrix = matrix;
        this.matrixRow0 = matrix.getRow(0);
        this.matrixRow1 = matrix.getRow(1);
    }

    public Matrix3d matrix() {
        return this.matrix;
    }

    public Vector2i transform(Vector2i vector) {
        return this.transform(vector.getX(), vector.getY());
    }

    public Vector2i transform(int x, int y) {
        return new Vector2i(this.transformX(x, y), this.transformY(x, y));
    }

    public int transformX(Vector2i vector) {
        return this.transformX(vector.getX(), vector.getY());
    }

    public int transformX(int x, int y) {
        return GenericMath.floor((double)(this.matrixRow0.dot((float)x, (float)y, 1.0f) + (double)GenericMath.FLT_EPSILON));
    }

    public int transformY(Vector2i vector) {
        return this.transformY(vector.getX(), vector.getY());
    }

    public int transformY(int x, int y) {
        return GenericMath.floor((double)(this.matrixRow1.dot((float)x, (float)y, 1.0f) + (double)GenericMath.FLT_EPSILON));
    }

    public DiscreteTransform2 invert() {
        return new DiscreteTransform2(this.matrix.invert());
    }

    public DiscreteTransform2 compose(DiscreteTransform2 that) {
        return new DiscreteTransform2(this.matrix.mul(that.matrix));
    }

    public DiscreteTransform2 andThen(DiscreteTransform2 that) {
        return that.compose(this);
    }

    public DiscreteTransform2 withTranslation(Vector2i vector) {
        return this.withTranslation(vector.getX(), vector.getY());
    }

    public DiscreteTransform2 withTranslation(int x, int y) {
        return new DiscreteTransform2(this.matrix.translate((float)x, (float)y));
    }

    public DiscreteTransform2 withScale(int a) {
        return this.withScale(a, a);
    }

    public DiscreteTransform2 withScale(Vector2i vector) {
        return this.withScale(vector.getX(), vector.getY());
    }

    public DiscreteTransform2 withScale(int x, int y) {
        if (x == 0) {
            throw new IllegalArgumentException("x == 0");
        }
        if (y == 0) {
            throw new IllegalArgumentException("y == 0");
        }
        return new DiscreteTransform2(this.matrix.scale((float)x, (float)y, 1.0f));
    }

    public DiscreteTransform2 withRotation(int quarterTurns) {
        return new DiscreteTransform2(this.matrix.rotate(Complexd.fromAngleDeg((float)(quarterTurns * 90))));
    }

    public DiscreteTransform2 withRotation(int quarterTurns, Vector2i point, boolean tileCorner) {
        Vector2d pointDouble = point.toDouble();
        if (tileCorner) {
            pointDouble = pointDouble.add(0.5, 0.5);
        }
        return new DiscreteTransform2(this.matrix.translate(pointDouble.negate()).rotate(Complexd.fromAngleDeg((float)(quarterTurns * 90))).translate(pointDouble));
    }

    public DiscreteTransform2 withRotation(int halfTurns, Vector2i point, boolean tileCornerX, boolean tileCornerY) {
        Vector2d pointDouble = point.toDouble();
        if (tileCornerX) {
            pointDouble = pointDouble.add(0.5, 0.0);
        }
        if (tileCornerY) {
            pointDouble = pointDouble.add(0.0, 0.5);
        }
        return new DiscreteTransform2(this.matrix.translate(pointDouble.negate()).rotate(Complexd.fromAngleDeg((float)(halfTurns * 180))).translate(pointDouble));
    }

    public DiscreteTransform2 withTransformation(DiscreteTransform2 transform) {
        return new DiscreteTransform2(transform.matrix().mul(this.matrix()));
    }

    public static Optional<DiscreteTransform2> of(Matrix3d matrix) {
        if (Arrays.stream(matrix.toArray()).anyMatch(value -> Math.rint(value) != value)) {
            return Optional.empty();
        }
        return Optional.of(new DiscreteTransform2(matrix));
    }

    public static DiscreteTransform2 fromTranslation(Vector2i vector) {
        return DiscreteTransform2.fromTranslation(vector.getX(), vector.getY());
    }

    public static DiscreteTransform2 fromTranslation(int x, int y) {
        return new DiscreteTransform2(Matrix3d.createTranslation((float)x, (float)y));
    }

    public static DiscreteTransform2 fromScale(int a) {
        return DiscreteTransform2.fromScale(a, a);
    }

    public static DiscreteTransform2 fromScale(Vector2i vector) {
        return DiscreteTransform2.fromScale(vector.getX(), vector.getY());
    }

    public static DiscreteTransform2 fromScale(int x, int y) {
        if (x == 0) {
            throw new IllegalArgumentException("x == 0");
        }
        if (y == 0) {
            throw new IllegalArgumentException("y == 0");
        }
        return new DiscreteTransform2(Matrix3d.createScaling((float)x, (float)y, (float)1.0f));
    }

    public static DiscreteTransform2 fromRotation(int quarterTurns) {
        return new DiscreteTransform2(Matrix3d.createRotation((Complexd)Complexd.fromAngleDeg((float)(quarterTurns * 90))));
    }

    public static DiscreteTransform2 fromRotation(int quarterTurns, Vector2i point, boolean tileCorner) {
        Vector2d pointDouble = point.toDouble();
        if (tileCorner) {
            pointDouble = pointDouble.add(0.5, 0.5);
        }
        return new DiscreteTransform2(Matrix3d.createTranslation((Vector2d)pointDouble.negate()).rotate(Complexd.fromAngleDeg((float)(quarterTurns * 90))).translate(pointDouble));
    }

    public static DiscreteTransform2 fromRotation(int halfTurns, Vector2i point, boolean tileCornerX, boolean tileCornerY) {
        Vector2d pointDouble = point.toDouble();
        if (tileCornerX) {
            pointDouble = pointDouble.add(0.5, 0.0);
        }
        if (tileCornerY) {
            pointDouble = pointDouble.add(0.0, 0.5);
        }
        return new DiscreteTransform2(Matrix3d.createTranslation((Vector2d)pointDouble.negate()).rotate(Complexd.fromAngleDeg((float)(halfTurns * 180))).translate(pointDouble));
    }

    public static DiscreteTransform2 rotationAroundCenter(int quarterTurns, Vector2i size) {
        boolean yEven;
        if (size.getX() <= 0) {
            throw new IllegalArgumentException("The size on x must be positive");
        }
        if (size.getY() <= 0) {
            throw new IllegalArgumentException("The size on y must be positive");
        }
        boolean mul180 = (quarterTurns & 1) == 0;
        boolean xEven = (size.getX() & 1) == 0;
        boolean bl = yEven = (size.getY() & 1) == 0;
        if (!mul180 || xEven != yEven) {
            throw new IllegalArgumentException("The size must have the same parity on all axes for rotations that are not a multiple of 180 degrees");
        }
        Vector2i center = size.sub(1, 1).div(2);
        if (mul180) {
            return DiscreteTransform2.fromRotation(quarterTurns, center, xEven, yEven);
        }
        return DiscreteTransform2.fromRotation(quarterTurns, center, xEven);
    }
}

