/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.CopyableBuilder;
import org.spongepowered.math.vector.Vector3d;

public interface WorldBorder {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public double newDiameter();

    public double diameter();

    public void setDiameter(double var1);

    default public void setDiameter(double diameter, long duration, TemporalUnit temporalUnit) {
        this.setDiameter(diameter, Duration.of(duration, temporalUnit));
    }

    public void setDiameter(double var1, Duration var3);

    default public void setDiameter(double startDiameter, double endDiameter, long duration, TemporalUnit temporalUnit) {
        this.setDiameter(startDiameter, endDiameter, Duration.of(duration, temporalUnit));
    }

    public void setDiameter(double var1, double var3, Duration var5);

    public Duration timeRemaining();

    public void setCenter(double var1, double var3);

    public Vector3d center();

    public Duration warningTime();

    default public void setWarningTime(long time, TemporalUnit temporalUnit) {
        this.setWarningTime(Duration.of(time, temporalUnit));
    }

    public void setWarningTime(Duration var1);

    public double warningDistance();

    public void setWarningDistance(double var1);

    public double damageThreshold();

    public void setDamageThreshold(double var1);

    public double damageAmount();

    public void setDamageAmount(double var1);

    default public void copyPropertiesFrom(WorldBorder border) {
        this.setCenter(border.center().getX(), border.center().getZ());
        this.setDamageAmount(border.damageAmount());
        this.setDamageThreshold(border.damageThreshold());
        this.setDiameter(border.diameter(), border.newDiameter(), border.timeRemaining());
        this.setWarningDistance(border.warningDistance());
        this.setWarningTime(border.warningTime());
    }

    public static interface Builder
    extends org.spongepowered.api.util.Builder<WorldBorder, Builder>,
    CopyableBuilder<WorldBorder, Builder> {
        @Override
        public Builder from(WorldBorder var1);

        public Builder diameter(double var1);

        public Builder center(double var1, double var3);

        default public Builder warningTime(long time, TemporalUnit temporalUnit) {
            return this.warningTime(Duration.of(time, temporalUnit));
        }

        public Builder warningTime(Duration var1);

        public Builder warningDistance(double var1);

        public Builder damageThreshold(double var1);

        public Builder damageAmount(double var1);

        public WorldBorder build();
    }
}

