/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.chunk;

import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.annotation.DoNotStore;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.chunk.ProtoChunk;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.math.vector.Vector3i;

@DoNotStore
public interface Chunk
extends ProtoChunk<Chunk>,
EntityVolume.Mutable<Chunk> {
    public World<?, ?> world();

    public boolean loadChunk(boolean var1);

    public boolean unloadChunk();

    @Override
    public long inhabitedTime();

    default public Optional<Chunk> neighbor(Direction direction) {
        return this.neighbor(direction, false);
    }

    default public Optional<Chunk> neighbor(Direction direction, boolean shouldLoad) {
        Optional<Vector3i> neighborPosition = Sponge.server().chunkLayout().moveToChunk(this.chunkPosition(), direction);
        return neighborPosition.flatMap(vector3i -> this.world().loadChunk((Vector3i)vector3i, shouldLoad));
    }
}

