/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.generation;

import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.generation.ConfigurableChunkGenerator;
import org.spongepowered.api.world.generation.config.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.NoiseGeneratorConfig;
import org.spongepowered.api.world.generation.config.structure.StructureGenerationConfig;

public interface ChunkGenerator {
    public static <T extends FlatGeneratorConfig> ConfigurableChunkGenerator<T> flat(T config) {
        return Sponge.game().factoryProvider().provide(Factory.class).flat(Objects.requireNonNull(config, "config"));
    }

    public static <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, T config) {
        return Sponge.game().factoryProvider().provide(Factory.class).noise(Objects.requireNonNull(provider, "provider"), Objects.requireNonNull(config, "config"));
    }

    public static <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider provider, long seed, T config) {
        return Sponge.game().factoryProvider().provide(Factory.class).noise(Objects.requireNonNull(provider, "provider"), seed, Objects.requireNonNull(config, "config"));
    }

    public static ConfigurableChunkGenerator<NoiseGeneratorConfig> overworld() {
        return Sponge.game().factoryProvider().provide(Factory.class).overworld();
    }

    public static ConfigurableChunkGenerator<NoiseGeneratorConfig> theNether() {
        return Sponge.game().factoryProvider().provide(Factory.class).theNether();
    }

    public static ConfigurableChunkGenerator<NoiseGeneratorConfig> theEnd() {
        return Sponge.game().factoryProvider().provide(Factory.class).theEnd();
    }

    public BiomeProvider biomeProvider();

    public StructureGenerationConfig structureConfig();

    public static interface Factory {
        public <T extends FlatGeneratorConfig> ConfigurableChunkGenerator<T> flat(T var1);

        public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider var1, T var2);

        public <T extends NoiseGeneratorConfig> ConfigurableChunkGenerator<T> noise(BiomeProvider var1, long var2, T var4);

        public ConfigurableChunkGenerator<NoiseGeneratorConfig> overworld();

        public ConfigurableChunkGenerator<NoiseGeneratorConfig> theNether();

        public ConfigurableChunkGenerator<NoiseGeneratorConfig> theEnd();
    }
}

