/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.generation;

import java.util.Objects;
import org.spongepowered.api.Server;
import org.spongepowered.api.world.ProtoWorld;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.generation.PrimitiveChunk;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.math.vector.Vector3i;

public interface GenerationRegion
extends ProtoWorld<GenerationRegion> {
    public ServerWorld world();

    @Override
    default public Server engine() {
        return this.world().engine();
    }

    @Override
    default public Difficulty difficulty() {
        return this.world().difficulty();
    }

    public Vector3i centerChunkPos();

    default public int centerChunkX() {
        return this.centerChunkPos().getX();
    }

    default public int centerChunkY() {
        return this.centerChunkPos().getY();
    }

    default public int centerChunkZ() {
        return this.centerChunkPos().getZ();
    }

    default public PrimitiveChunk chunkAtBlock(Vector3i position) {
        Objects.requireNonNull(position, "position");
        return this.chunkAtBlock(position.getX(), position.getY(), position.getZ());
    }

    default public PrimitiveChunk chunkAtBlock(int x, int y, int z) {
        return this.chunk(this.engine().chunkLayout().toChunk(x, y, z).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot convert (%s, %s, %s) to chunk coordinates.", x, y, z))));
    }

    default public PrimitiveChunk chunk(Vector3i chunkPosition) {
        Objects.requireNonNull(chunkPosition, "chunkPosition");
        return this.chunk(chunkPosition.getX(), chunkPosition.getY(), chunkPosition.getZ());
    }

    public PrimitiveChunk chunk(int var1, int var2, int var3);
}

