/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.storage;

import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.util.Direction;
import org.spongepowered.math.vector.Vector3i;

public interface ChunkLayout {
    public Vector3i chunkSize();

    public Vector3i spaceMax();

    public Vector3i spaceMin();

    public Vector3i spaceSize();

    public Vector3i spaceOrigin();

    default public boolean isValidChunk(Vector3i coords) {
        Objects.requireNonNull(coords, "coords");
        return this.isValidChunk(coords.getX(), coords.getY(), coords.getZ());
    }

    default public boolean isValidChunk(int x, int y, int z) {
        return x >= this.spaceMin().getX() && x <= this.spaceMax().getX() && y >= this.spaceMin().getY() && y <= this.spaceMax().getY() && z >= this.spaceMin().getZ() && z <= this.spaceMax().getZ();
    }

    default public boolean isInChunk(Vector3i localCoords) {
        Objects.requireNonNull(localCoords, "localCoords");
        return this.isInChunk(localCoords.getX(), localCoords.getY(), localCoords.getZ());
    }

    public boolean isInChunk(int var1, int var2, int var3);

    default public boolean isInChunk(Vector3i worldCoords, Vector3i chunkCoords) {
        Objects.requireNonNull(worldCoords, "worldCoords");
        Objects.requireNonNull(chunkCoords, "chunkCoords");
        return this.isInChunk(worldCoords.getX(), worldCoords.getY(), worldCoords.getZ(), chunkCoords.getX(), chunkCoords.getY(), chunkCoords.getZ());
    }

    public boolean isInChunk(int var1, int var2, int var3, int var4, int var5, int var6);

    default public Optional<Vector3i> toChunk(Vector3i worldCoords) {
        Objects.requireNonNull(worldCoords, "worldCoords");
        return this.toChunk(worldCoords.getX(), worldCoords.getY(), worldCoords.getZ());
    }

    default public Optional<Vector3i> toChunk(int x, int y, int z) {
        Vector3i chunkCoords = this.forceToChunk(x, y, z);
        return this.isValidChunk(chunkCoords) ? Optional.of(chunkCoords) : Optional.empty();
    }

    default public Optional<Vector3i> toWorld(Vector3i chunkCoords) {
        Objects.requireNonNull(chunkCoords, "chunkCoords");
        return this.toWorld(chunkCoords.getX(), chunkCoords.getY(), chunkCoords.getZ());
    }

    default public Optional<Vector3i> toWorld(int x, int y, int z) {
        return this.isValidChunk(x, y, z) ? Optional.of(this.forceToWorld(x, y, z)) : Optional.empty();
    }

    default public Vector3i forceToChunk(Vector3i worldCoords) {
        Objects.requireNonNull(worldCoords, "worldCoords");
        return this.forceToChunk(worldCoords.getX(), worldCoords.getY(), worldCoords.getZ());
    }

    public Vector3i forceToChunk(int var1, int var2, int var3);

    default public Vector3i forceToWorld(Vector3i chunkCoords) {
        Objects.requireNonNull(chunkCoords, "chunkCoords");
        return this.forceToWorld(chunkCoords.getX(), chunkCoords.getY(), chunkCoords.getZ());
    }

    public Vector3i forceToWorld(int var1, int var2, int var3);

    default public Optional<Vector3i> addToChunk(Vector3i chunkCoords, Vector3i chunkOffset) {
        Objects.requireNonNull(chunkCoords, "chunkCoords");
        Objects.requireNonNull(chunkOffset, "chunkOffset");
        return this.addToChunk(chunkCoords.getX(), chunkCoords.getY(), chunkCoords.getZ(), chunkOffset.getX(), chunkOffset.getY(), chunkOffset.getZ());
    }

    default public Optional<Vector3i> addToChunk(int cx, int cy, int cz, int ox, int oy, int oz) {
        Vector3i newChunkCoords = new Vector3i(cx + ox, cy + oy, cz + oz);
        return this.isValidChunk(newChunkCoords) ? Optional.of(newChunkCoords) : Optional.empty();
    }

    default public Optional<Vector3i> moveToChunk(Vector3i chunkCoords, Direction direction) {
        return this.moveToChunk(chunkCoords, direction, 1);
    }

    default public Optional<Vector3i> moveToChunk(int x, int y, int z, Direction direction) {
        return this.moveToChunk(new Vector3i(x, y, z), direction);
    }

    default public Optional<Vector3i> moveToChunk(Vector3i chunkCoords, Direction direction, int steps) {
        Objects.requireNonNull(direction, "direction");
        if (direction.isSecondaryOrdinal()) {
            throw new IllegalArgumentException("Secondary cardinal directions cannot be used here");
        }
        return this.addToChunk(chunkCoords, direction.asBlockOffset().mul(steps));
    }

    default public Optional<Vector3i> moveToChunk(int x, int y, int z, Direction direction, int steps) {
        return this.moveToChunk(new Vector3i(x, y, z), direction, steps);
    }
}

