/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume;

import java.util.Objects;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.math.vector.Vector3d;

public class EntityHit {
    private final Entity entity;
    private final Vector3d intersection;
    private final Vector3d normal;
    private final double distance;

    public EntityHit(Entity entity, Vector3d intersection, Vector3d normal, double distance) {
        this.entity = Objects.requireNonNull(entity, "entity");
        this.intersection = Objects.requireNonNull(intersection, "intersection");
        this.normal = Objects.requireNonNull(normal, "normal");
        this.distance = distance;
    }

    public Entity entity() {
        return this.entity;
    }

    public Vector3d intersection() {
        return this.intersection;
    }

    public Vector3d normal() {
        return this.normal;
    }

    public double distance() {
        return this.distance;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityHit)) {
            return false;
        }
        EntityHit entityHit = (EntityHit)other;
        return this.entity.equals(entityHit.entity) && this.intersection.equals((Object)entityHit.intersection) && this.normal.equals((Object)entityHit.normal) && this.distance == entityHit.distance;
    }

    public int hashCode() {
        int result = this.entity.hashCode();
        result = 31 * result + this.intersection.hashCode();
        result = 31 * result + this.normal.hashCode();
        result = 31 * result + Double.hashCode(this.distance);
        return result;
    }

    public String toString() {
        return "EntityHit(" + this.entity + " at " + this.intersection + " on " + this.normal + ")";
    }
}

