/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.archetype.entity;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.world.volume.ImmutableVolume;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.UnmodifiableVolume;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public interface EntityArchetypeVolume
extends Volume {
    public Collection<EntityArchetype> entityArchetypes();

    public Collection<EntityArchetype> entityArchetypes(Predicate<EntityArchetype> var1);

    public static interface Immutable
    extends Unmodifiable<Immutable>,
    ImmutableVolume {
    }

    public static interface Mutable<M extends Mutable<M>>
    extends Streamable<M>,
    MutableVolume {
        default public void addEntity(EntityArchetype archetype, Vector3d position) {
            this.addEntity(EntityArchetypeEntry.of(Objects.requireNonNull(archetype, "EntityArchetype cannot be null"), Objects.requireNonNull(position, "Position cannot be null")));
        }

        public void addEntity(EntityArchetypeEntry var1);
    }

    public static interface Unmodifiable<U extends Unmodifiable<U>>
    extends EntityArchetypeVolume,
    UnmodifiableVolume,
    BlockVolume.Unmodifiable<U>,
    Streamable<U> {
    }

    public static interface Streamable<B extends Streamable<B>>
    extends EntityArchetypeVolume {
        public VolumeStream<B, EntityArchetype> entityArchetypeStream(Vector3i var1, Vector3i var2, StreamOptions var3);

        public Stream<EntityArchetypeEntry> entitiesByPosition();
    }
}

