/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.block;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.volume.ImmutableVolume;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.UnmodifiableVolume;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.block.BlockVolumeFactory;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.math.vector.Vector2i;
import org.spongepowered.math.vector.Vector3i;

public interface BlockVolume
extends Volume {
    public static Mutable<@NonNull ?> empty(Vector3i min, Vector3i max) {
        return BlockVolume.empty(PaletteTypes.BLOCK_STATE_PALETTE.get().create(Sponge.game().registries(), RegistryTypes.BLOCK_TYPE), BlockTypes.AIR, min, max);
    }

    public static Mutable<@NonNull ?> empty(Palette<BlockState, BlockType> palette, RegistryReference<BlockType> defaultState, Vector3i min, Vector3i max) {
        return Sponge.game().factoryProvider().provide(BlockVolumeFactory.class).empty(palette, defaultState, min, max);
    }

    public BlockState block(int var1, int var2, int var3);

    default public BlockState block(Vector3i vector3i) {
        return this.block(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public FluidState fluid(int var1, int var2, int var3);

    default public FluidState fluid(Vector3i vector3i) {
        return this.fluid(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public int highestYAt(int var1, int var2);

    default public int highestYAt(Vector2i column) {
        return this.highestYAt(column.getX(), column.getY());
    }

    default public Vector3i highestPositionAt(Vector3i position) {
        return new Vector3i(position.getX(), this.highestYAt(position.getX(), position.getZ()), position.getZ());
    }

    public static interface Mutable<M extends Mutable<M>>
    extends Streamable<M>,
    MutableVolume {
        default public boolean setBlock(Vector3i position, BlockState block) {
            return this.setBlock(position.getX(), position.getY(), position.getZ(), block);
        }

        public boolean setBlock(int var1, int var2, int var3, BlockState var4);

        default public boolean removeBlock(Vector3i position) {
            return this.removeBlock(position.getX(), position.getY(), position.getZ());
        }

        public boolean removeBlock(int var1, int var2, int var3);
    }

    public static interface Immutable
    extends Unmodifiable<Immutable>,
    ImmutableVolume {
    }

    public static interface Unmodifiable<U extends Unmodifiable<U>>
    extends BlockVolume,
    Streamable<U>,
    UnmodifiableVolume {
    }

    public static interface Streamable<B extends Streamable<B>>
    extends BlockVolume {
        public VolumeStream<B, BlockState> blockStateStream(Vector3i var1, Vector3i var2, StreamOptions var3);
    }
}

