/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.block.entity;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.UnmodifiableVolume;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.math.vector.Vector3i;

public interface BlockEntityVolume
extends BlockVolume,
Volume {
    public Collection<? extends BlockEntity> blockEntities();

    default public Collection<? extends BlockEntity> blockEntities(Predicate<? super BlockEntity> filter) {
        Objects.requireNonNull(filter);
        return this.blockEntities().stream().filter(filter).collect(Collectors.toList());
    }

    default public Optional<? extends BlockEntity> blockEntity(Vector3i position) {
        Objects.requireNonNull(position);
        return this.blockEntity(position.getX(), position.getY(), position.getZ());
    }

    public Optional<? extends BlockEntity> blockEntity(int var1, int var2, int var3);

    public static interface Mutable<M extends Mutable<M>>
    extends Streamable<M>,
    BlockVolume.Mutable<M>,
    MutableVolume {
        default public void addBlockEntity(Vector3i pos, BlockEntity blockEntity) {
            this.addBlockEntity(pos.getX(), pos.getY(), pos.getZ(), blockEntity);
        }

        public void addBlockEntity(int var1, int var2, int var3, BlockEntity var4);

        default public void removeBlockEntity(Vector3i pos) {
            this.removeBlockEntity(pos.getX(), pos.getY(), pos.getZ());
        }

        public void removeBlockEntity(int var1, int var2, int var3);
    }

    public static interface Streamable<T extends Streamable<T>>
    extends BlockEntityVolume {
        public VolumeStream<T, BlockEntity> blockEntityStream(Vector3i var1, Vector3i var2, StreamOptions var3);
    }

    public static interface Unmodifiable<U extends Unmodifiable<U>>
    extends BlockEntityVolume,
    Streamable<U>,
    UnmodifiableVolume,
    BlockVolume.Unmodifiable<U> {
    }
}

