/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.game;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.math.vector.Vector3i;

public interface LocationBaseDataHolder {
    default public <E> Optional<E> get(Vector3i position, Key<? extends Value<E>> key) {
        return this.get(position.getX(), position.getY(), position.getZ(), key);
    }

    default public <E> Optional<E> get(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key) {
        return this.get(position.getX(), position.getY(), position.getZ(), key.get());
    }

    public <E> Optional<E> get(int var1, int var2, int var3, Key<? extends Value<E>> var4);

    default public <E> Optional<E> get(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key) {
        return this.get(x, y, z, key.get());
    }

    default public OptionalInt getInt(Vector3i position, Key<? extends Value<Integer>> key) {
        return this.getInt(position.getX(), position.getY(), position.getZ(), key);
    }

    default public OptionalInt getInt(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<Integer>>> key) {
        return this.getInt(position.getX(), position.getY(), position.getZ(), key.get());
    }

    default public OptionalInt getInt(int x, int y, int z, Key<? extends Value<Integer>> key) {
        return this.get(x, y, z, key).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    default public OptionalInt getInt(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<Integer>>> key) {
        return this.get(x, y, z, key.get()).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    default public OptionalDouble getDouble(Vector3i position, Key<? extends Value<Double>> key) {
        return this.getDouble(position.getX(), position.getY(), position.getZ(), key);
    }

    default public OptionalDouble getDouble(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<Double>>> key) {
        return this.getDouble(position.getX(), position.getY(), position.getZ(), key.get());
    }

    default public OptionalDouble getDouble(int x, int y, int z, Key<? extends Value<Double>> key) {
        return this.get(x, y, z, key).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    default public OptionalDouble getDouble(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<Double>>> key) {
        return this.get(x, y, z, key).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    default public OptionalLong getLong(Vector3i position, Key<? extends Value<Long>> key) {
        return this.getLong(position.getX(), position.getY(), position.getZ(), key);
    }

    default public OptionalLong getLong(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<Long>>> key) {
        return this.getLong(position.getX(), position.getY(), position.getZ(), key.get());
    }

    default public OptionalLong getLong(int x, int y, int z, Key<? extends Value<Long>> key) {
        return this.get(x, y, z, key).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    default public OptionalLong getLong(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<Long>>> key) {
        return this.get(x, y, z, key).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    default public <E> E require(Vector3i position, Key<? extends Value<E>> key) {
        return this.require(position.getX(), position.getY(), position.getZ(), key);
    }

    default public <E> E require(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key) {
        return this.require(position.getX(), position.getY(), position.getZ(), key.get());
    }

    default public <E> E require(int x, int y, int z, Key<? extends Value<E>> key) {
        Optional<E> optional = this.get(x, y, z, key);
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.toString()));
    }

    default public <E> E require(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key) {
        Optional<E> optional = this.get(x, y, z, key.get());
        if (optional.isPresent()) {
            return optional.get();
        }
        throw new NoSuchElementException(String.format("Could not retrieve value for key '%s'", key.get().toString()));
    }

    default public <E> @Nullable E orNull(Vector3i position, Key<? extends Value<E>> key) {
        return this.get(position.getX(), position.getY(), position.getZ(), key).orElse(null);
    }

    default public <E> @Nullable E orNull(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key) {
        return this.get(position.getX(), position.getY(), position.getZ(), key.get()).orElse(null);
    }

    default public <E> @Nullable E orNull(int x, int y, int z, Key<? extends Value<E>> key) {
        return this.get(x, y, z, key).orElse(null);
    }

    default public <E> @Nullable E orNull(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key) {
        return this.get(x, y, z, key.get()).orElse(null);
    }

    default public <E> E orElse(Vector3i position, Key<? extends Value<E>> key, E defaultValue) {
        return this.get(position.getX(), position.getY(), position.getZ(), key).orElse(Objects.requireNonNull(defaultValue));
    }

    default public <E> E orElse(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key, E defaultValue) {
        return this.get(position.getX(), position.getY(), position.getZ(), key.get()).orElse(Objects.requireNonNull(defaultValue));
    }

    default public <E> E orElse(int x, int y, int z, Key<? extends Value<E>> key, E defaultValue) {
        return this.get(x, y, z, key).orElse(Objects.requireNonNull(defaultValue));
    }

    default public <E> E orElse(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key, E defaultValue) {
        return this.get(x, y, z, key.get()).orElse(Objects.requireNonNull(defaultValue));
    }

    default public <E> E orElse(Vector3i position, Key<? extends Value<E>> key, Supplier<? extends E> defaultValue) {
        return this.get(position.getX(), position.getY(), position.getZ(), key).orElseGet(Objects.requireNonNull(defaultValue));
    }

    default public <E> E orElse(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key, Supplier<? extends E> defaultValue) {
        return this.get(position.getX(), position.getY(), position.getZ(), key.get()).orElseGet(Objects.requireNonNull(defaultValue));
    }

    default public <E> E orElse(int x, int y, int z, Key<? extends Value<E>> key, Supplier<E> defaultValue) {
        return this.get(x, y, z, key).orElseGet(Objects.requireNonNull(defaultValue));
    }

    default public <E> E orElse(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key, Supplier<? extends E> defaultValue) {
        return this.get(x, y, z, key.get()).orElseGet(Objects.requireNonNull(defaultValue));
    }

    default public <E, V extends Value<E>> Optional<V> getValue(Vector3i position, Key<V> key) {
        return this.getValue(position.getX(), position.getY(), position.getZ(), key);
    }

    default public <E, V extends Value<E>> Optional<V> getValue(Vector3i position, Supplier<? extends Key<V>> key) {
        return this.getValue(position.getX(), position.getY(), position.getZ(), key.get());
    }

    public <E, V extends Value<E>> Optional<V> getValue(int var1, int var2, int var3, Key<V> var4);

    default public <E, V extends Value<E>> Optional<V> getValue(int x, int y, int z, DefaultedRegistryReference<? extends Key<V>> key) {
        return this.getValue(x, y, z, key.get());
    }

    default public boolean supports(Vector3i position, Key<?> key) {
        return this.supports(position.getX(), position.getY(), position.getZ(), key);
    }

    default public boolean supports(Vector3i position, Supplier<? extends Key<?>> key) {
        return this.supports(position.getX(), position.getY(), position.getZ(), key.get());
    }

    public boolean supports(int var1, int var2, int var3, Key<?> var4);

    default public boolean supports(int x, int y, int z, Supplier<? extends Key<?>> key) {
        return this.supports(x, y, z, key.get());
    }

    default public boolean supports(Vector3i position, Value<?> value) {
        return this.supports(position.getX(), position.getY(), position.getZ(), value.key());
    }

    default public boolean supports(int x, int y, int z, Value<?> value) {
        return this.supports(x, y, z, value.key());
    }

    default public Set<Key<?>> keys(Vector3i position) {
        return this.keys(position.getX(), position.getY(), position.getZ());
    }

    public Set<Key<?>> keys(int var1, int var2, int var3);

    default public Set<Value.Immutable<?>> getValues(Vector3i position) {
        return this.getValues(position.getX(), position.getY(), position.getZ());
    }

    public Set<Value.Immutable<?>> getValues(int var1, int var2, int var3);

    public static interface Mutable
    extends LocationBaseDataHolder {
        default public <E> DataTransactionResult transform(Vector3i position, Key<? extends Value<E>> key, Function<E, E> function) {
            return this.transform(position.getX(), position.getY(), position.getZ(), key, function);
        }

        default public <E> DataTransactionResult transform(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key, Function<E, E> function) {
            return this.transform(position.getX(), position.getY(), position.getZ(), key.get(), function);
        }

        default public <E> DataTransactionResult transform(int x, int y, int z, Key<? extends Value<E>> key, Function<E, E> function) {
            Optional optional;
            if (this.supports(x, y, z, key) && (optional = this.get(x, y, z, key)).isPresent()) {
                return this.offer(x, y, z, key, function.apply(optional.get()));
            }
            return DataTransactionResult.failNoData();
        }

        default public <E> DataTransactionResult transform(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key, Function<E, E> function) {
            Optional optional;
            if (this.supports(x, y, z, key) && (optional = this.get(x, y, z, key.get())).isPresent()) {
                return this.offer(x, y, z, key.get(), function.apply(optional.get()));
            }
            return DataTransactionResult.failNoData();
        }

        default public <E> DataTransactionResult offer(Vector3i position, Key<? extends Value<E>> key, E value) {
            return this.offer(position.getX(), position.getY(), position.getZ(), key, value);
        }

        default public <E> DataTransactionResult offer(Vector3i position, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key, E value) {
            return this.offer(position.getX(), position.getY(), position.getZ(), key.get(), value);
        }

        public <E> DataTransactionResult offer(int var1, int var2, int var3, Key<? extends Value<E>> var4, E var5);

        default public <E> DataTransactionResult offer(int x, int y, int z, DefaultedRegistryReference<? extends Key<? extends Value<E>>> key, E value) {
            return this.offer(x, y, z, key.get(), value);
        }

        default public <E> DataTransactionResult offer(Vector3i position, Value<E> value) {
            return this.offer(position.getX(), position.getY(), position.getZ(), value.key(), value.get());
        }

        default public <E> DataTransactionResult offer(int x, int y, int z, Value<E> value) {
            return this.offer(x, y, z, value.key(), value.get());
        }

        default public DataTransactionResult remove(Vector3i position, Key<?> key) {
            return this.remove(position.getX(), position.getY(), position.getZ(), key);
        }

        default public DataTransactionResult remove(Vector3i position, DefaultedRegistryReference<? extends Key<?>> key) {
            return this.remove(position.getX(), position.getY(), position.getZ(), key.get());
        }

        public DataTransactionResult remove(int var1, int var2, int var3, Key<?> var4);

        default public DataTransactionResult remove(int x, int y, int z, DefaultedRegistryReference<? extends Key<?>> key) {
            return this.remove(x, y, z, key.get());
        }

        default public DataTransactionResult undo(Vector3i position, DataTransactionResult result) {
            return this.undo(position.getX(), position.getY(), position.getZ(), result);
        }

        public DataTransactionResult undo(int var1, int var2, int var3, DataTransactionResult var4);

        default public DataTransactionResult copyFrom(Vector3i to, ValueContainer from) {
            return this.copyFrom(to.getX(), to.getY(), to.getZ(), from);
        }

        public DataTransactionResult copyFrom(int var1, int var2, int var3, ValueContainer var4);

        default public DataTransactionResult copyFrom(Vector3i positionTo, Vector3i positionFrom) {
            return this.copyFrom(positionTo.getX(), positionTo.getY(), positionTo.getZ(), positionFrom.getX(), positionFrom.getY(), positionFrom.getZ(), MergeFunction.REPLACEMENT_PREFERRED);
        }

        default public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, int xFrom, int yFrom, int zFrom) {
            return this.copyFrom(xTo, yTo, zTo, xFrom, yFrom, zFrom, MergeFunction.REPLACEMENT_PREFERRED);
        }

        default public DataTransactionResult copyFrom(Vector3i to, ValueContainer from, MergeFunction function) {
            return this.copyFrom(to.getX(), to.getY(), to.getZ(), from, function);
        }

        public DataTransactionResult copyFrom(int var1, int var2, int var3, ValueContainer var4, MergeFunction var5);

        default public DataTransactionResult copyFrom(Vector3i positionTo, Vector3i positionFrom, MergeFunction function) {
            return this.copyFrom(positionTo.getX(), positionTo.getY(), positionTo.getZ(), positionFrom.getX(), positionFrom.getY(), positionFrom.getZ(), function);
        }

        public DataTransactionResult copyFrom(int var1, int var2, int var3, int var4, int var5, int var6, MergeFunction var7);

        default public boolean validateRawData(Vector3i position, DataView container) {
            return this.validateRawData(position.getX(), position.getY(), position.getZ(), container);
        }

        public boolean validateRawData(int var1, int var2, int var3, DataView var4);

        default public void setRawData(Vector3i position, DataView container) throws InvalidDataException {
            this.setRawData(position.getX(), position.getY(), position.getZ(), container);
        }

        public void setRawData(int var1, int var2, int var3, DataView var4) throws InvalidDataException;
    }
}

